/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations.indexes;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.IndexErrors;
import net.ravendb.client.documents.operations.IMaintenanceOperation;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetIndexErrorsOperation
implements IMaintenanceOperation<IndexErrors[]> {
    private final String[] _indexNames;

    public GetIndexErrorsOperation() {
        this._indexNames = null;
    }

    public GetIndexErrorsOperation(String[] indexNames) {
        this._indexNames = indexNames;
    }

    @Override
    public RavenCommand<IndexErrors[]> getCommand(DocumentConventions conventions) {
        return new GetIndexErrorsCommand(this._indexNames);
    }

    private static class GetIndexErrorsCommand
    extends RavenCommand<IndexErrors[]> {
        private final String[] _indexNames;

        public GetIndexErrorsCommand(String[] indexNames) {
            super(IndexErrors[].class);
            this._indexNames = indexNames;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/indexes/errors";
            if (this._indexNames != null && this._indexNames.length > 0) {
                url.value = url.value + "?";
                for (String indexName : this._indexNames) {
                    url.value = url.value + "&name=" + indexName;
                }
            }
            return new HttpGet();
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                GetIndexErrorsCommand.throwInvalidResponse();
                return;
            }
            ArrayNode results = (ArrayNode)this.mapper.readTree(response).get("Results");
            this.result = new IndexErrors[results.size()];
            for (int i = 0; i < results.size(); ++i) {
                ((IndexErrors[])this.result)[i] = (IndexErrors)this.mapper.convertValue((Object)results.get(i), IndexErrors.class);
            }
        }

        @Override
        public boolean isReadRequest() {
            return true;
        }
    }
}

