/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations.indexes;

import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.IndexStats;
import net.ravendb.client.documents.operations.IMaintenanceOperation;
import net.ravendb.client.documents.operations.ResultsResponse;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.UrlUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetIndexStatisticsOperation
implements IMaintenanceOperation<IndexStats> {
    private final String _indexName;

    public GetIndexStatisticsOperation(String indexName) {
        if (indexName == null) {
            throw new IllegalArgumentException("IndexName cannot be null");
        }
        this._indexName = indexName;
    }

    @Override
    public RavenCommand<IndexStats> getCommand(DocumentConventions conventions) {
        return new GetIndexStatisticsCommand(this._indexName);
    }

    private static class GetIndexStatisticsCommand
    extends RavenCommand<IndexStats> {
        private final String _indexName;

        public GetIndexStatisticsCommand(String indexName) {
            super(IndexStats.class);
            if (indexName == null) {
                throw new IllegalArgumentException("IndexName cannot be null");
            }
            this._indexName = indexName;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/indexes/stats?name=" + UrlUtils.escapeDataString(this._indexName);
            return new HttpGet();
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            IndexStats[] results;
            if (response == null) {
                GetIndexStatisticsCommand.throwInvalidResponse();
            }
            if ((results = (IndexStats[])((ResultsResponse.GetIndexStatisticsResponse)this.mapper.readValue(response, ResultsResponse.GetIndexStatisticsResponse.class)).getResults()).length != 1) {
                GetIndexStatisticsCommand.throwInvalidResponse();
            }
            this.result = results[0];
        }

        @Override
        public boolean isReadRequest() {
            return true;
        }
    }
}

