/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations.indexes;

import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.IndexDefinition;
import net.ravendb.client.documents.operations.IMaintenanceOperation;
import net.ravendb.client.documents.operations.ResultsResponse;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetIndexesOperation
implements IMaintenanceOperation<IndexDefinition[]> {
    private final int _start;
    private final int _pageSize;

    public GetIndexesOperation(int start, int pageSize) {
        this._start = start;
        this._pageSize = pageSize;
    }

    @Override
    public RavenCommand<IndexDefinition[]> getCommand(DocumentConventions conventions) {
        return new GetIndexesCommand(this._start, this._pageSize);
    }

    private static class GetIndexesCommand
    extends RavenCommand<IndexDefinition[]> {
        private final int _start;
        private final int _pageSize;

        public GetIndexesCommand(int start, int pageSize) {
            super(IndexDefinition[].class);
            this._start = start;
            this._pageSize = pageSize;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/indexes?start=" + this._start + "&pageSize=" + this._pageSize;
            return new HttpGet();
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                GetIndexesCommand.throwInvalidResponse();
            }
            this.result = ((ResultsResponse.GetIndexesResponse)this.mapper.readValue(response, ResultsResponse.GetIndexesResponse.class)).getResults();
        }

        @Override
        public boolean isReadRequest() {
            return true;
        }
    }
}

