/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations.indexes;

import java.io.IOException;
import java.io.Serializable;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.IMaintenanceOperation;
import net.ravendb.client.documents.queries.TermsQueryResult;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.UrlUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetTermsOperation
implements IMaintenanceOperation<String[]> {
    private final String _indexName;
    private final String _field;
    private final String _fromValue;
    private final Integer _pageSize;

    public GetTermsOperation(String indexName, String field, String fromValue) {
        this(indexName, field, fromValue, null);
    }

    public GetTermsOperation(String indexName, String field, String fromValue, Integer pageSize) {
        if (indexName == null) {
            throw new IllegalArgumentException("IndexName cannot be null");
        }
        if (field == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        this._indexName = indexName;
        this._field = field;
        this._fromValue = fromValue;
        this._pageSize = pageSize;
    }

    @Override
    public RavenCommand<String[]> getCommand(DocumentConventions conventions) {
        return new GetTermsCommand(this._indexName, this._field, this._fromValue, this._pageSize);
    }

    private static class GetTermsCommand
    extends RavenCommand<String[]> {
        private final String _indexName;
        private final String _field;
        private final String _fromValue;
        private final Integer _pageSize;

        public GetTermsCommand(String indexName, String field, String fromValue) {
            this(indexName, field, fromValue, null);
        }

        public GetTermsCommand(String indexName, String field, String fromValue, Integer pageSize) {
            super(String[].class);
            if (indexName == null) {
                throw new IllegalArgumentException("IndexName cannot be null");
            }
            if (field == null) {
                throw new IllegalArgumentException("Field cannot be null");
            }
            this._indexName = indexName;
            this._field = field;
            this._fromValue = fromValue;
            this._pageSize = pageSize;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/indexes/terms?name=" + UrlUtils.escapeDataString(this._indexName) + "&field=" + UrlUtils.escapeDataString(this._field) + "&fromValue=" + (String)ObjectUtils.firstNonNull((Object[])new String[]{this._fromValue, ""}) + "&pageSize=" + ObjectUtils.firstNonNull((Object[])new Serializable[]{this._pageSize, ""});
            return new HttpGet();
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                GetTermsCommand.throwInvalidResponse();
            }
            TermsQueryResult termResult = (TermsQueryResult)this.mapper.readValue(response, TermsQueryResult.class);
            this.result = termResult.getTerms().toArray(new String[0]);
        }

        @Override
        public boolean isReadRequest() {
            return true;
        }
    }
}

