/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations.indexes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.IndexDefinition;
import net.ravendb.client.documents.operations.IMaintenanceOperation;
import net.ravendb.client.documents.session.EntityToJson;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class IndexHasChangedOperation
implements IMaintenanceOperation<Boolean> {
    private final IndexDefinition _definition;

    public IndexHasChangedOperation(IndexDefinition definition) {
        if (definition == null) {
            throw new IllegalArgumentException("IndexDefinition cannot be null");
        }
        this._definition = definition;
    }

    @Override
    public RavenCommand<Boolean> getCommand(DocumentConventions conventions) {
        return new IndexHasChangedCommand(conventions, this._definition);
    }

    private static class IndexHasChangedCommand
    extends RavenCommand<Boolean> {
        private final ObjectNode _definition;

        public IndexHasChangedCommand(DocumentConventions conventions, IndexDefinition definition) {
            super(Boolean.class);
            this._definition = EntityToJson.convertEntityToJson(definition, conventions);
        }

        @Override
        public boolean isReadRequest() {
            return false;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/indexes/has-changed";
            HttpPost request = new HttpPost();
            request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
                try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                    generator.writeTree((TreeNode)this._definition);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, ContentType.APPLICATION_JSON));
            return request;
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                IndexHasChangedCommand.throwInvalidResponse();
            }
            this.result = this.mapper.readTree(response).get("Changed").asBoolean();
        }
    }
}

