/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.operations.indexes;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.IndexLockMode;
import net.ravendb.client.documents.operations.IVoidMaintenanceOperation;
import net.ravendb.client.documents.session.EntityToJson;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.http.VoidRavenCommand;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class SetIndexesLockOperation
implements IVoidMaintenanceOperation {
    private final Parameters _parameters;

    public SetIndexesLockOperation(String indexName, IndexLockMode mode) {
        if (indexName == null) {
            throw new IllegalArgumentException("IndexName cannot be null");
        }
        this._parameters = new Parameters();
        this._parameters.setMode(mode);
        this._parameters.setIndexNames(new String[]{indexName});
    }

    public SetIndexesLockOperation(Parameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException("Parameters cannot be null");
        }
        if (parameters.getIndexNames() == null || parameters.getIndexNames().length == 0) {
            throw new IllegalArgumentException("IndexNames cannot be null or empty");
        }
        this._parameters = parameters;
    }

    @Override
    public VoidRavenCommand getCommand(DocumentConventions conventions) {
        return new SetIndexLockCommand(conventions, this._parameters);
    }

    public static class Parameters {
        private String[] indexNames;
        private IndexLockMode mode;

        public String[] getIndexNames() {
            return this.indexNames;
        }

        public void setIndexNames(String[] indexNames) {
            this.indexNames = indexNames;
        }

        public IndexLockMode getMode() {
            return this.mode;
        }

        public void setMode(IndexLockMode mode) {
            this.mode = mode;
        }
    }

    private static class SetIndexLockCommand
    extends VoidRavenCommand {
        private ObjectNode _parameters;

        public SetIndexLockCommand(DocumentConventions conventions, Parameters parameters) {
            if (conventions == null) {
                throw new IllegalArgumentException("Conventions cannot be null");
            }
            if (parameters == null) {
                throw new IllegalArgumentException("Parameters cannot be null");
            }
            this._parameters = EntityToJson.convertEntityToJson(parameters, conventions);
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/indexes/set-lock";
            HttpPost request = new HttpPost();
            request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
                try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                    generator.writeTree((TreeNode)this._parameters);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, ContentType.APPLICATION_JSON));
            return request;
        }
    }
}

