/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.queries;

import java.io.IOException;
import java.util.Optional;
import net.ravendb.client.Parameters;
import net.ravendb.client.documents.queries.IndexQueryWithParameters;
import net.ravendb.client.documents.queries.QueryHashCalculator;

public class IndexQuery
extends IndexQueryWithParameters<Parameters> {
    private boolean disableCaching;

    public IndexQuery() {
    }

    public IndexQuery(String query) {
        this.setQuery(query);
    }

    public boolean isDisableCaching() {
        return this.disableCaching;
    }

    public void setDisableCaching(boolean disableCaching) {
        this.disableCaching = disableCaching;
    }

    public String getQueryHash() {
        QueryHashCalculator hasher = new QueryHashCalculator();
        try {
            hasher.write(this.getQuery());
            hasher.write(this.isWaitForNonStaleResults());
            hasher.write(this.isSkipDuplicateChecking());
            hasher.write(Optional.ofNullable(this.getWaitForNonStaleResultsTimeout()).map(x -> x.toMillis()).orElse(0L));
            hasher.write(this.getStart());
            hasher.write(this.getPageSize());
            hasher.write((Parameters)this.getQueryParameters());
            return hasher.getHash();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to calculate hash", e);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexQuery that = (IndexQuery)o;
        return this.disableCaching == that.disableCaching;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.disableCaching ? 1 : 0);
        return result;
    }
}

