/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.queries.spatial;

import java.util.function.Function;
import net.ravendb.client.documents.indexes.spatial.SpatialRelation;
import net.ravendb.client.documents.session.tokens.QueryToken;
import net.ravendb.client.documents.session.tokens.ShapeToken;
import net.ravendb.client.documents.session.tokens.WhereOperator;
import net.ravendb.client.documents.session.tokens.WhereToken;

public abstract class SpatialCriteria {
    private final SpatialRelation _relation;
    private final double _distanceErrorPct;

    protected SpatialCriteria(SpatialRelation relation, double distanceErrorPct) {
        this._relation = relation;
        this._distanceErrorPct = distanceErrorPct;
    }

    protected abstract ShapeToken getShapeToken(Function<Object, String> var1);

    public QueryToken toQueryToken(String fieldName, Function<Object, String> addQueryParameter) {
        WhereOperator whereOperator;
        ShapeToken shapeToken = this.getShapeToken(addQueryParameter);
        switch (this._relation) {
            case WITHIN: {
                whereOperator = WhereOperator.SPATIAL_WITHIN;
                break;
            }
            case CONTAINS: {
                whereOperator = WhereOperator.SPATIAL_CONTAINS;
                break;
            }
            case DISJOINT: {
                whereOperator = WhereOperator.SPATIAL_DISJOINT;
                break;
            }
            case INTERSECTS: {
                whereOperator = WhereOperator.SPATIAL_INTERSECTS;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return WhereToken.create(whereOperator, fieldName, null, new WhereToken.WhereOptions(shapeToken, this._distanceErrorPct));
    }
}

