/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session;

import com.google.common.base.Defaults;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.ravendb.client.Parameters;
import net.ravendb.client.documents.commands.QueryCommand;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.indexes.spatial.SpatialRelation;
import net.ravendb.client.documents.indexes.spatial.SpatialUnits;
import net.ravendb.client.documents.queries.GroupBy;
import net.ravendb.client.documents.queries.IndexQuery;
import net.ravendb.client.documents.queries.QueryFieldUtil;
import net.ravendb.client.documents.queries.QueryOperator;
import net.ravendb.client.documents.queries.QueryResult;
import net.ravendb.client.documents.queries.SearchOperator;
import net.ravendb.client.documents.queries.spatial.DynamicSpatialField;
import net.ravendb.client.documents.queries.spatial.SpatialCriteria;
import net.ravendb.client.documents.session.BeforeQueryExecutedEventArgs;
import net.ravendb.client.documents.session.CmpXchg;
import net.ravendb.client.documents.session.DocumentQueryHelper;
import net.ravendb.client.documents.session.EnumerableUtils;
import net.ravendb.client.documents.session.IAbstractDocumentQuery;
import net.ravendb.client.documents.session.IDocumentSession;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import net.ravendb.client.documents.session.MethodCall;
import net.ravendb.client.documents.session.OrderingType;
import net.ravendb.client.documents.session.QueryStatistics;
import net.ravendb.client.documents.session.WhereParams;
import net.ravendb.client.documents.session.operations.QueryOperation;
import net.ravendb.client.documents.session.tokens.CloseSubclauseToken;
import net.ravendb.client.documents.session.tokens.DeclareToken;
import net.ravendb.client.documents.session.tokens.DistinctToken;
import net.ravendb.client.documents.session.tokens.FieldsToFetchToken;
import net.ravendb.client.documents.session.tokens.FromToken;
import net.ravendb.client.documents.session.tokens.GroupByCountToken;
import net.ravendb.client.documents.session.tokens.GroupByKeyToken;
import net.ravendb.client.documents.session.tokens.GroupBySumToken;
import net.ravendb.client.documents.session.tokens.GroupByToken;
import net.ravendb.client.documents.session.tokens.IntersectMarkerToken;
import net.ravendb.client.documents.session.tokens.LoadToken;
import net.ravendb.client.documents.session.tokens.NegateToken;
import net.ravendb.client.documents.session.tokens.OpenSubclauseToken;
import net.ravendb.client.documents.session.tokens.OrderByToken;
import net.ravendb.client.documents.session.tokens.QueryOperatorToken;
import net.ravendb.client.documents.session.tokens.QueryToken;
import net.ravendb.client.documents.session.tokens.ShapeToken;
import net.ravendb.client.documents.session.tokens.TrueToken;
import net.ravendb.client.documents.session.tokens.WhereOperator;
import net.ravendb.client.documents.session.tokens.WhereToken;
import net.ravendb.client.primitives.CleanCloseable;
import net.ravendb.client.primitives.Reference;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDocumentQuery<T, TSelf extends AbstractDocumentQuery<T, TSelf>>
implements IAbstractDocumentQuery<T> {
    protected final Class<T> clazz;
    private final Map<String, String> _aliasToGroupByFieldName = new HashMap<String, String>();
    protected QueryOperator defaultOperator = QueryOperator.AND;
    protected Set<Class> rootTypes = new HashSet<Class>();
    protected boolean negate;
    private final String indexName;
    private final String collectionName;
    private int _currentClauseDepth;
    protected String queryRaw;
    protected Parameters queryParameters = new Parameters();
    protected boolean isIntersect;
    protected boolean isGroupBy;
    protected final InMemoryDocumentSessionOperations theSession;
    protected Integer pageSize;
    protected List<QueryToken> selectTokens = new LinkedList<QueryToken>();
    protected final FromToken fromToken;
    protected final DeclareToken declareToken;
    protected final List<LoadToken> loadTokens;
    protected FieldsToFetchToken fieldsToFetchToken;
    protected List<QueryToken> whereTokens = new LinkedList<QueryToken>();
    protected List<QueryToken> groupByTokens = new LinkedList<QueryToken>();
    protected List<QueryToken> orderByTokens = new LinkedList<QueryToken>();
    protected int start;
    private final DocumentConventions _conventions;
    protected Duration timeout;
    protected boolean theWaitForNonStaleResults;
    protected Set<String> includes = new HashSet<String>();
    protected QueryStatistics queryStats = new QueryStatistics();
    protected boolean disableEntitiesTracking;
    protected boolean disableCaching;
    private boolean _isInMoreLikeThis;
    protected List<Consumer<IndexQuery>> beforeQueryExecutedCallback = new ArrayList<Consumer<IndexQuery>>();
    protected List<Consumer<QueryResult>> afterQueryExecutedCallback = new ArrayList<Consumer<QueryResult>>();
    protected QueryOperation queryOperation;

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public String getCollectionName() {
        return this.collectionName;
    }

    public boolean isDistinct() {
        return !this.selectTokens.isEmpty() && this.selectTokens.get(0) instanceof DistinctToken;
    }

    @Override
    public DocumentConventions getConventions() {
        return this._conventions;
    }

    public IDocumentSession getSession() {
        return (IDocumentSession)((Object)this.theSession);
    }

    @Override
    public boolean isDynamicMapReduce() {
        return !this.groupByTokens.isEmpty();
    }

    private static Duration getDefaultTimeout() {
        return Duration.ofSeconds(15L);
    }

    protected AbstractDocumentQuery(Class<T> clazz, InMemoryDocumentSessionOperations session, String indexName, String collectionName, boolean isGroupBy, DeclareToken declareToken, List<LoadToken> loadTokens) {
        this(clazz, session, indexName, collectionName, isGroupBy, declareToken, loadTokens, null);
    }

    protected AbstractDocumentQuery(Class<T> clazz, InMemoryDocumentSessionOperations session, String indexName, String collectionName, boolean isGroupBy, DeclareToken declareToken, List<LoadToken> loadTokens, String fromAlias) {
        this.clazz = clazz;
        this.rootTypes.add(clazz);
        this.isGroupBy = isGroupBy;
        this.indexName = indexName;
        this.collectionName = collectionName;
        this.fromToken = FromToken.create(indexName, collectionName, fromAlias);
        this.declareToken = declareToken;
        this.loadTokens = loadTokens;
        this.theSession = session;
        this._addAfterQueryExecutedListener(this::updateStatsAndHighlightings);
        this._conventions = session == null ? new DocumentConventions() : session.getConventions();
    }

    public void _usingDefaultOperator(QueryOperator operator) {
        if (!this.whereTokens.isEmpty()) {
            throw new IllegalStateException("Default operator can only be set before any where clause is added.");
        }
        this.defaultOperator = operator;
    }

    @Override
    public void _waitForNonStaleResults(Duration waitTimeout) {
        this.theWaitForNonStaleResults = true;
        this.timeout = (Duration)ObjectUtils.firstNonNull((Object[])new Duration[]{waitTimeout, AbstractDocumentQuery.getDefaultTimeout()});
    }

    protected QueryOperation initializeQueryOperation() {
        IndexQuery indexQuery = this.getIndexQuery();
        return new QueryOperation(this.theSession, this.indexName, indexQuery, this.fieldsToFetchToken, this.disableEntitiesTracking, false, false);
    }

    public IndexQuery getIndexQuery() {
        String query = this.toString();
        IndexQuery indexQuery = this.generateIndexQuery(query);
        this.invokeBeforeQueryExecuted(indexQuery);
        return indexQuery;
    }

    @Override
    public List<String> getProjectionFields() {
        return this.fieldsToFetchToken != null && this.fieldsToFetchToken.projections != null ? Arrays.asList(this.fieldsToFetchToken.projections) : Collections.emptyList();
    }

    @Override
    public void _randomOrdering() {
        this.assertNoRawQuery();
        this.orderByTokens.add(OrderByToken.random);
    }

    @Override
    public void _randomOrdering(String seed) {
        this.assertNoRawQuery();
        if (StringUtils.isBlank((CharSequence)seed)) {
            this._randomOrdering();
            return;
        }
        this.orderByTokens.add(OrderByToken.createRandom(seed));
    }

    protected void addGroupByAlias(String fieldName, String projectedName) {
        this._aliasToGroupByFieldName.put(projectedName, fieldName);
    }

    private void assertNoRawQuery() {
        if (this.queryRaw != null) {
            throw new IllegalStateException("RawQuery was called, cannot modify this query by calling on operations that would modify the query (such as Where, Select, OrderBy, GroupBy, etc)");
        }
    }

    public void _addParameter(String name, Object value) {
        if (this.queryParameters.containsKey(name)) {
            throw new IllegalStateException("The parameter " + name + " was already added");
        }
        this.queryParameters.put(name, value);
    }

    @Override
    public void _groupBy(String fieldName, String ... fieldNames) {
        GroupBy[] mapping = (GroupBy[])Arrays.stream(fieldNames).map(x -> GroupBy.field(x)).toArray(GroupBy[]::new);
        this._groupBy(GroupBy.field(fieldName), mapping);
    }

    @Override
    public void _groupBy(GroupBy field, GroupBy ... fields) {
        if (!this.fromToken.isDynamic()) {
            throw new IllegalStateException("groupBy only works with dynamic queries");
        }
        this.assertNoRawQuery();
        this.isGroupBy = true;
        String fieldName = this.ensureValidFieldName(field.getField(), false);
        this.groupByTokens.add(GroupByToken.create(fieldName, field.getMethod()));
        if (fields == null || fields.length <= 0) {
            return;
        }
        for (GroupBy item : fields) {
            fieldName = this.ensureValidFieldName(item.getField(), false);
            this.groupByTokens.add(GroupByToken.create(fieldName, item.getMethod()));
        }
    }

    @Override
    public void _groupByKey(String fieldName) {
        this._groupByKey(fieldName, null);
    }

    @Override
    public void _groupByKey(String fieldName, String projectedName) {
        this.assertNoRawQuery();
        this.isGroupBy = true;
        if (projectedName != null && this._aliasToGroupByFieldName.containsKey(projectedName)) {
            String aliasedFieldName = this._aliasToGroupByFieldName.get(projectedName);
            if (fieldName == null || fieldName.equalsIgnoreCase(projectedName)) {
                fieldName = aliasedFieldName;
            }
        } else if (fieldName != null && this._aliasToGroupByFieldName.containsValue(fieldName)) {
            String aliasedFieldName;
            fieldName = aliasedFieldName = this._aliasToGroupByFieldName.get(fieldName);
        }
        this.selectTokens.add(GroupByKeyToken.create(fieldName, projectedName));
    }

    @Override
    public void _groupBySum(String fieldName) {
        this._groupBySum(fieldName, null);
    }

    @Override
    public void _groupBySum(String fieldName, String projectedName) {
        this.assertNoRawQuery();
        this.isGroupBy = true;
        fieldName = this.ensureValidFieldName(fieldName, false);
        this.selectTokens.add(GroupBySumToken.create(fieldName, projectedName));
    }

    @Override
    public void _groupByCount() {
        this._groupByCount(null);
    }

    @Override
    public void _groupByCount(String projectedName) {
        this.assertNoRawQuery();
        this.isGroupBy = true;
        this.selectTokens.add(GroupByCountToken.create(projectedName));
    }

    @Override
    public void _whereTrue() {
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, null);
        tokens.add(TrueToken.INSTANCE);
    }

    @Override
    public void _include(String path) {
        this.includes.add(path);
    }

    @Override
    public void _take(int count) {
        this.pageSize = count;
    }

    @Override
    public void _skip(int count) {
        this.start = count;
    }

    public void _whereLucene(String fieldName, String whereClause) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        WhereToken whereToken = WhereToken.create(WhereOperator.LUCENE, fieldName, this.addQueryParameter(whereClause));
        tokens.add(whereToken);
    }

    @Override
    public void _openSubclause() {
        ++this._currentClauseDepth;
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, null);
        tokens.add(OpenSubclauseToken.INSTANCE);
    }

    @Override
    public void _closeSubclause() {
        --this._currentClauseDepth;
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        tokens.add(CloseSubclauseToken.INSTANCE);
    }

    @Override
    public void _whereEquals(String fieldName, Object value) {
        this._whereEquals(fieldName, value, false);
    }

    @Override
    public void _whereEquals(String fieldName, Object value, boolean exact) {
        WhereParams params = new WhereParams();
        params.setFieldName(fieldName);
        params.setValue(value);
        params.setExact(exact);
        this._whereEquals(params);
    }

    @Override
    public void _whereEquals(String fieldName, MethodCall method) {
        this._whereEquals(fieldName, method, false);
    }

    @Override
    public void _whereEquals(String fieldName, MethodCall method, boolean exact) {
        this._whereEquals(fieldName, (Object)method, exact);
    }

    @Override
    public void _whereEquals(WhereParams whereParams) {
        if (this.negate) {
            this.negate = false;
            this._whereNotEquals(whereParams);
            return;
        }
        whereParams.setFieldName(this.ensureValidFieldName(whereParams.getFieldName(), whereParams.isNestedPath()));
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        if (this.ifValueIsMethod(WhereOperator.EQUALS, whereParams, tokens)) {
            return;
        }
        Object transformToEqualValue = this.transformValue(whereParams);
        String addQueryParameter = this.addQueryParameter(transformToEqualValue);
        WhereToken whereToken = WhereToken.create(WhereOperator.EQUALS, whereParams.getFieldName(), addQueryParameter, new WhereToken.WhereOptions(whereParams.isExact()));
        tokens.add(whereToken);
    }

    private boolean ifValueIsMethod(WhereOperator op, WhereParams whereParams, List<QueryToken> tokens) {
        if (whereParams.getValue() instanceof MethodCall) {
            MethodCall mc = (MethodCall)whereParams.getValue();
            String[] args = new String[mc.args.length];
            for (int i = 0; i < mc.args.length; ++i) {
                args[i] = this.addQueryParameter(mc.args[i]);
            }
            Class<?> type = mc.getClass();
            if (!CmpXchg.class.equals(type)) {
                throw new IllegalArgumentException("Unknown method " + type);
            }
            WhereToken token = WhereToken.create(op, whereParams.getFieldName(), null, new WhereToken.WhereOptions(WhereToken.MethodsType.CMP_X_CHG, args, mc.accessPath, whereParams.isExact()));
            tokens.add(token);
            return true;
        }
        return false;
    }

    @Override
    public void _whereNotEquals(String fieldName, Object value) {
        this._whereNotEquals(fieldName, value, false);
    }

    @Override
    public void _whereNotEquals(String fieldName, Object value, boolean exact) {
        WhereParams params = new WhereParams();
        params.setFieldName(fieldName);
        params.setValue(value);
        params.setExact(exact);
        this._whereNotEquals(params);
    }

    @Override
    public void _whereNotEquals(String fieldName, MethodCall method) {
        this._whereNotEquals(fieldName, (Object)method);
    }

    @Override
    public void _whereNotEquals(String fieldName, MethodCall method, boolean exact) {
        this._whereNotEquals(fieldName, (Object)method, exact);
    }

    @Override
    public void _whereNotEquals(WhereParams whereParams) {
        if (this.negate) {
            this.negate = false;
            this._whereEquals(whereParams);
            return;
        }
        Object transformToEqualValue = this.transformValue(whereParams);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        whereParams.setFieldName(this.ensureValidFieldName(whereParams.getFieldName(), whereParams.isNestedPath()));
        if (this.ifValueIsMethod(WhereOperator.NOT_EQUALS, whereParams, tokens)) {
            return;
        }
        WhereToken whereToken = WhereToken.create(WhereOperator.NOT_EQUALS, whereParams.getFieldName(), this.addQueryParameter(transformToEqualValue), new WhereToken.WhereOptions(whereParams.isExact()));
        tokens.add(whereToken);
    }

    @Override
    public void negateNext() {
        this.negate = !this.negate;
    }

    @Override
    public void _whereIn(String fieldName, Collection<Object> values) {
        this._whereIn(fieldName, values, false);
    }

    @Override
    public void _whereIn(String fieldName, Collection<Object> values, boolean exact) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        WhereToken whereToken = WhereToken.create(WhereOperator.IN, fieldName, this.addQueryParameter(this.transformCollection(fieldName, AbstractDocumentQuery.unpackCollection(values))));
        tokens.add(whereToken);
    }

    @Override
    public void _whereStartsWith(String fieldName, Object value) {
        WhereParams whereParams = new WhereParams();
        whereParams.setFieldName(fieldName);
        whereParams.setValue(value);
        whereParams.setAllowWildcards(true);
        Object transformToEqualValue = this.transformValue(whereParams);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        whereParams.setFieldName(this.ensureValidFieldName(whereParams.getFieldName(), whereParams.isNestedPath()));
        this.negateIfNeeded(tokens, whereParams.getFieldName());
        WhereToken whereToken = WhereToken.create(WhereOperator.STARTS_WITH, whereParams.getFieldName(), this.addQueryParameter(transformToEqualValue));
        tokens.add(whereToken);
    }

    @Override
    public void _whereEndsWith(String fieldName, Object value) {
        WhereParams whereParams = new WhereParams();
        whereParams.setFieldName(fieldName);
        whereParams.setValue(value);
        whereParams.setAllowWildcards(true);
        Object transformToEqualValue = this.transformValue(whereParams);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        whereParams.setFieldName(this.ensureValidFieldName(whereParams.getFieldName(), whereParams.isNestedPath()));
        this.negateIfNeeded(tokens, whereParams.getFieldName());
        WhereToken whereToken = WhereToken.create(WhereOperator.ENDS_WITH, whereParams.getFieldName(), this.addQueryParameter(transformToEqualValue));
        tokens.add(whereToken);
    }

    @Override
    public void _whereBetween(String fieldName, Object start, Object end) {
        this._whereBetween(fieldName, start, end, false);
    }

    @Override
    public void _whereBetween(String fieldName, Object start, Object end, boolean exact) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        WhereParams startParams = new WhereParams();
        startParams.setValue(start);
        startParams.setFieldName(fieldName);
        WhereParams endParams = new WhereParams();
        endParams.setValue(end);
        endParams.setFieldName(fieldName);
        String fromParameterName = this.addQueryParameter(start == null ? "*" : this.transformValue(startParams, true));
        String toParameterName = this.addQueryParameter(start == null ? "NULL" : this.transformValue(endParams, true));
        WhereToken whereToken = WhereToken.create(WhereOperator.BETWEEN, fieldName, null, new WhereToken.WhereOptions(exact, fromParameterName, toParameterName));
        tokens.add(whereToken);
    }

    @Override
    public void _whereGreaterThan(String fieldName, Object value) {
        this._whereGreaterThan(fieldName, value, false);
    }

    @Override
    public void _whereGreaterThan(String fieldName, Object value, boolean exact) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        WhereParams whereParams = new WhereParams();
        whereParams.setValue(value);
        whereParams.setFieldName(fieldName);
        String parameter = this.addQueryParameter(value == null ? "*" : this.transformValue(whereParams, true));
        WhereToken whereToken = WhereToken.create(WhereOperator.GREATER_THAN, fieldName, parameter, new WhereToken.WhereOptions(exact));
        tokens.add(whereToken);
    }

    @Override
    public void _whereGreaterThanOrEqual(String fieldName, Object value) {
        this._whereGreaterThanOrEqual(fieldName, value, false);
    }

    @Override
    public void _whereGreaterThanOrEqual(String fieldName, Object value, boolean exact) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        WhereParams whereParams = new WhereParams();
        whereParams.setValue(value);
        whereParams.setFieldName(fieldName);
        String parameter = this.addQueryParameter(value == null ? "*" : this.transformValue(whereParams, true));
        WhereToken whereToken = WhereToken.create(WhereOperator.GREATER_THAN_OR_EQUAL, fieldName, parameter, new WhereToken.WhereOptions(exact));
        tokens.add(whereToken);
    }

    @Override
    public void _whereLessThan(String fieldName, Object value) {
        this._whereLessThan(fieldName, value, false);
    }

    @Override
    public void _whereLessThan(String fieldName, Object value, boolean exact) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        WhereParams whereParams = new WhereParams();
        whereParams.setValue(value);
        whereParams.setFieldName(fieldName);
        String parameter = this.addQueryParameter(value == null ? "NULL" : this.transformValue(whereParams, true));
        WhereToken whereToken = WhereToken.create(WhereOperator.LESS_THAN, fieldName, parameter, new WhereToken.WhereOptions(exact));
        tokens.add(whereToken);
    }

    @Override
    public void _whereLessThanOrEqual(String fieldName, Object value) {
        this._whereLessThanOrEqual(fieldName, value, false);
    }

    @Override
    public void _whereLessThanOrEqual(String fieldName, Object value, boolean exact) {
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        WhereParams whereParams = new WhereParams();
        whereParams.setValue(value);
        whereParams.setFieldName(fieldName);
        String parameter = this.addQueryParameter(value == null ? "NULL" : this.transformValue(whereParams, true));
        WhereToken whereToken = WhereToken.create(WhereOperator.LESS_THAN_OR_EQUAL, fieldName, parameter, new WhereToken.WhereOptions(exact));
        tokens.add(whereToken);
    }

    @Override
    public void _whereRegex(String fieldName, String pattern) {
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        WhereParams whereParams = new WhereParams();
        whereParams.setValue(pattern);
        whereParams.setFieldName(fieldName);
        String parameter = this.addQueryParameter(this.transformValue(whereParams));
        WhereToken whereToken = WhereToken.create(WhereOperator.REGEX, fieldName, parameter);
        tokens.add(whereToken);
    }

    @Override
    public void _andAlso() {
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        if (tokens.isEmpty()) {
            return;
        }
        if (tokens.get(tokens.size() - 1) instanceof QueryOperatorToken) {
            throw new IllegalStateException("Cannot add AND, previous token was already an operator token.");
        }
        tokens.add(QueryOperatorToken.AND);
    }

    @Override
    public void _orElse() {
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        if (tokens.isEmpty()) {
            return;
        }
        if (tokens.get(tokens.size() - 1) instanceof QueryOperatorToken) {
            throw new IllegalStateException("Cannot add OR, previous token was already an operator token.");
        }
        tokens.add(QueryOperatorToken.OR);
    }

    @Override
    public void _boost(double boost) {
        if (boost == 1.0) {
            return;
        }
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        if (tokens.isEmpty()) {
            throw new IllegalStateException("Missing where clause");
        }
        QueryToken whereToken = tokens.get(tokens.size() - 1);
        if (!(whereToken instanceof WhereToken)) {
            throw new IllegalStateException("Missing where clause");
        }
        if (boost <= 0.0) {
            throw new IllegalArgumentException("Boost factor must be a positive number");
        }
        ((WhereToken)whereToken).getOptions().setBoost(boost);
    }

    @Override
    public void _fuzzy(double fuzzy) {
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        if (tokens.isEmpty()) {
            throw new IllegalStateException("Missing where clause");
        }
        QueryToken whereToken = tokens.get(tokens.size() - 1);
        if (!(whereToken instanceof WhereToken)) {
            throw new IllegalStateException("Missing where clause");
        }
        if (fuzzy < 0.0 || fuzzy > 1.0) {
            throw new IllegalArgumentException("Fuzzy distance must be between 0.0 and 1.0");
        }
        ((WhereToken)whereToken).getOptions().setFuzzy(fuzzy);
    }

    @Override
    public void _proximity(int proximity) {
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        if (tokens.isEmpty()) {
            throw new IllegalStateException("Missing where clause");
        }
        QueryToken whereToken = tokens.get(tokens.size() - 1);
        if (!(whereToken instanceof WhereToken)) {
            throw new IllegalStateException("Missing where clause");
        }
        if (proximity < 1) {
            throw new IllegalArgumentException("Proximity distance must be a positive number");
        }
        ((WhereToken)whereToken).getOptions().setProximity(proximity);
    }

    @Override
    public void _orderBy(String field) {
        this._orderBy(field, OrderingType.STRING);
    }

    @Override
    public void _orderBy(String field, OrderingType ordering) {
        this.assertNoRawQuery();
        String f = this.ensureValidFieldName(field, false);
        this.orderByTokens.add(OrderByToken.createAscending(f, ordering));
    }

    @Override
    public void _orderByDescending(String field) {
        this._orderByDescending(field, OrderingType.STRING);
    }

    @Override
    public void _orderByDescending(String field, OrderingType ordering) {
        this.assertNoRawQuery();
        String f = this.ensureValidFieldName(field, false);
        this.orderByTokens.add(OrderByToken.createDescending(f, ordering));
    }

    @Override
    public void _orderByScore() {
        this.assertNoRawQuery();
        this.orderByTokens.add(OrderByToken.scoreAscending);
    }

    @Override
    public void _orderByScoreDescending() {
        this.assertNoRawQuery();
        this.orderByTokens.add(OrderByToken.scoreDescending);
    }

    public void _statistics(Reference<QueryStatistics> stats) {
        stats.value = this.queryStats;
    }

    public void invokeAfterQueryExecuted(QueryResult result) {
        for (Consumer<QueryResult> consumer : this.afterQueryExecutedCallback) {
            consumer.accept(result);
        }
    }

    public void invokeBeforeQueryExecuted(IndexQuery query) {
        for (Consumer<IndexQuery> consumer : this.beforeQueryExecutedCallback) {
            consumer.accept(query);
        }
    }

    protected IndexQuery generateIndexQuery(String query) {
        IndexQuery indexQuery = new IndexQuery();
        indexQuery.setQuery(query);
        indexQuery.setStart(this.start);
        indexQuery.setWaitForNonStaleResults(this.theWaitForNonStaleResults);
        indexQuery.setWaitForNonStaleResultsTimeout(this.timeout);
        indexQuery.setQueryParameters(this.queryParameters);
        indexQuery.setDisableCaching(this.disableCaching);
        if (this.pageSize != null) {
            indexQuery.setPageSize(this.pageSize);
        }
        return indexQuery;
    }

    @Override
    public void _search(String fieldName, String searchTerms) {
        this._search(fieldName, searchTerms, SearchOperator.OR);
    }

    @Override
    public void _search(String fieldName, String searchTerms, SearchOperator operator) {
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        fieldName = this.ensureValidFieldName(fieldName, false);
        this.negateIfNeeded(tokens, fieldName);
        WhereToken whereToken = WhereToken.create(WhereOperator.SEARCH, fieldName, this.addQueryParameter(searchTerms), new WhereToken.WhereOptions(operator));
        tokens.add(whereToken);
    }

    @Override
    public String toString() {
        if (this.queryRaw != null) {
            return this.queryRaw;
        }
        if (this._currentClauseDepth != 0) {
            throw new IllegalStateException("A clause was not closed correctly within this query, current clause depth = " + this._currentClauseDepth);
        }
        StringBuilder queryText = new StringBuilder();
        this.buildDeclare(queryText);
        this.buildFrom(queryText);
        this.buildGroupBy(queryText);
        this.buildWhere(queryText);
        this.buildOrderBy(queryText);
        this.buildLoad(queryText);
        this.buildSelect(queryText);
        this.buildInclude(queryText);
        return queryText.toString();
    }

    private void buildInclude(StringBuilder queryText) {
        if (this.includes == null || this.includes.isEmpty()) {
            return;
        }
        queryText.append(" include ");
        boolean first = true;
        for (String include : this.includes) {
            if (!first) {
                queryText.append(",");
            }
            first = false;
            boolean requiredQuotes = false;
            for (int i = 0; i < include.length(); ++i) {
                char ch = include.charAt(i);
                if (Character.isLetterOrDigit(ch) || ch == '_' || ch == '.') continue;
                requiredQuotes = true;
                break;
            }
            if (requiredQuotes) {
                queryText.append("'").append(include.replaceAll("'", "\\'")).append("'");
                continue;
            }
            queryText.append(include);
        }
    }

    @Override
    public void _intersect() {
        QueryToken last;
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        if (tokens.size() > 0 && ((last = tokens.get(tokens.size() - 1)) instanceof WhereToken || last instanceof CloseSubclauseToken)) {
            this.isIntersect = true;
            tokens.add(IntersectMarkerToken.INSTANCE);
            return;
        }
        throw new IllegalStateException("Cannot add INTERSECT at this point.");
    }

    @Override
    public void _whereExists(String fieldName) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        tokens.add(WhereToken.create(WhereOperator.EXISTS, fieldName, null));
    }

    @Override
    public void _containsAny(String fieldName, Collection<Object> values) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        Collection<Object> array = this.transformCollection(fieldName, AbstractDocumentQuery.unpackCollection(values));
        WhereToken whereToken = WhereToken.create(WhereOperator.IN, fieldName, this.addQueryParameter(array), new WhereToken.WhereOptions(false));
        tokens.add(whereToken);
    }

    @Override
    public void _containsAll(String fieldName, Collection<Object> values) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        Collection<Object> array = this.transformCollection(fieldName, AbstractDocumentQuery.unpackCollection(values));
        if (array.isEmpty()) {
            tokens.add(TrueToken.INSTANCE);
            return;
        }
        WhereToken whereToken = WhereToken.create(WhereOperator.ALL_IN, fieldName, this.addQueryParameter(array));
        tokens.add(whereToken);
    }

    @Override
    public void _addRootType(Class clazz) {
        this.rootTypes.add(clazz);
    }

    @Override
    public void _distinct() {
        if (this.isDistinct()) {
            throw new IllegalStateException("The is already a distinct query");
        }
        if (this.selectTokens.isEmpty()) {
            this.selectTokens.add(DistinctToken.INSTANCE);
        } else {
            this.selectTokens.add(0, DistinctToken.INSTANCE);
        }
    }

    private void updateStatsAndHighlightings(QueryResult queryResult) {
        this.queryStats.updateQueryStats(queryResult);
    }

    private void buildSelect(StringBuilder writer) {
        if (this.selectTokens.isEmpty()) {
            return;
        }
        writer.append(" select ");
        if (this.selectTokens.size() == 1 && this.selectTokens.get(0) instanceof DistinctToken) {
            this.selectTokens.get(0).writeTo(writer);
            writer.append(" *");
            return;
        }
        for (int i = 0; i < this.selectTokens.size(); ++i) {
            QueryToken token = this.selectTokens.get(i);
            if (i > 0 && !(this.selectTokens.get(i - 1) instanceof DistinctToken)) {
                writer.append(",");
            }
            DocumentQueryHelper.addSpaceIfNeeded(i > 0 ? this.selectTokens.get(i - 1) : null, token, writer);
            token.writeTo(writer);
        }
    }

    private void buildFrom(StringBuilder writer) {
        this.fromToken.writeTo(writer);
    }

    private void buildDeclare(StringBuilder writer) {
        if (this.declareToken != null) {
            this.declareToken.writeTo(writer);
        }
    }

    private void buildLoad(StringBuilder writer) {
        if (this.loadTokens == null || this.loadTokens.isEmpty()) {
            return;
        }
        writer.append(" load ");
        for (int i = 0; i < this.loadTokens.size(); ++i) {
            if (i != 0) {
                writer.append(", ");
            }
            this.loadTokens.get(i).writeTo(writer);
        }
    }

    private void buildWhere(StringBuilder writer) {
        if (this.whereTokens.isEmpty()) {
            return;
        }
        writer.append(" where ");
        if (this.isIntersect) {
            writer.append("intersect(");
        }
        for (int i = 0; i < this.whereTokens.size(); ++i) {
            DocumentQueryHelper.addSpaceIfNeeded(i > 0 ? this.whereTokens.get(i - 1) : null, this.whereTokens.get(i), writer);
            this.whereTokens.get(i).writeTo(writer);
        }
        if (this.isIntersect) {
            writer.append(") ");
        }
    }

    private void buildGroupBy(StringBuilder writer) {
        if (this.groupByTokens.isEmpty()) {
            return;
        }
        writer.append(" group by ");
        boolean isFirst = true;
        for (QueryToken token : this.groupByTokens) {
            if (!isFirst) {
                writer.append(", ");
            }
            token.writeTo(writer);
            isFirst = false;
        }
    }

    private void buildOrderBy(StringBuilder writer) {
        if (this.orderByTokens.isEmpty()) {
            return;
        }
        writer.append(" order by ");
        boolean isFirst = true;
        for (QueryToken token : this.orderByTokens) {
            if (!isFirst) {
                writer.append(", ");
            }
            token.writeTo(writer);
            isFirst = false;
        }
    }

    private void appendOperatorIfNeeded(List<QueryToken> tokens) {
        QueryOperatorToken token;
        this.assertNoRawQuery();
        if (tokens.isEmpty()) {
            return;
        }
        QueryToken lastToken = tokens.get(tokens.size() - 1);
        if (!(lastToken instanceof WhereToken) && !(lastToken instanceof CloseSubclauseToken)) {
            return;
        }
        WhereToken lastWhere = null;
        for (int i = tokens.size() - 1; i >= 0; --i) {
            if (!(tokens.get(i) instanceof WhereToken)) continue;
            lastWhere = (WhereToken)tokens.get(i);
            break;
        }
        QueryOperatorToken queryOperatorToken = token = this.defaultOperator == QueryOperator.AND ? QueryOperatorToken.AND : QueryOperatorToken.OR;
        if (lastWhere != null && lastWhere.getOptions().getSearchOperator() != null) {
            token = QueryOperatorToken.OR;
        }
        tokens.add(token);
    }

    private Collection<Object> transformCollection(String fieldName, Collection<Object> values) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object value : values) {
            if (value instanceof Collection) {
                result.addAll(this.transformCollection(fieldName, (Collection)value));
                continue;
            }
            WhereParams nestedWhereParams = new WhereParams();
            nestedWhereParams.setAllowWildcards(true);
            nestedWhereParams.setFieldName(fieldName);
            nestedWhereParams.setValue(value);
            result.add(this.transformValue(nestedWhereParams));
        }
        return result;
    }

    private void negateIfNeeded(List<QueryToken> tokens, String fieldName) {
        if (!this.negate) {
            return;
        }
        this.negate = false;
        if (tokens.isEmpty() || tokens.get(tokens.size() - 1) instanceof OpenSubclauseToken) {
            if (fieldName != null) {
                this._whereExists(fieldName);
            } else {
                this._whereTrue();
            }
            this._andAlso();
        }
        tokens.add(NegateToken.INSTANCE);
    }

    private static Collection<Object> unpackCollection(Collection items) {
        ArrayList<Object> results = new ArrayList<Object>();
        for (Object item : items) {
            if (item instanceof Collection) {
                results.addAll(AbstractDocumentQuery.unpackCollection((Collection)item));
                continue;
            }
            results.add(item);
        }
        return results;
    }

    private String ensureValidFieldName(String fieldName, boolean isNestedPath) {
        if (this.theSession == null || this.theSession.getConventions() == null || isNestedPath || this.isGroupBy) {
            return QueryFieldUtil.escapeIfNecessary(fieldName);
        }
        for (Class rootType : this.rootTypes) {
            Field identityProperty = this.theSession.getConventions().getIdentityProperty(rootType);
            if (identityProperty == null || !identityProperty.getName().equals(fieldName)) continue;
            return "id()";
        }
        return QueryFieldUtil.escapeIfNecessary(fieldName);
    }

    private Object transformValue(WhereParams whereParams) {
        return this.transformValue(whereParams, false);
    }

    private Object transformValue(WhereParams whereParams, boolean forRange) {
        if (whereParams.getValue() == null) {
            return null;
        }
        if ("".equals(whereParams.getValue())) {
            return "";
        }
        Class<?> clazz = whereParams.getValue().getClass();
        if (Date.class.equals(clazz)) {
            return whereParams.getValue();
        }
        if (String.class.equals(clazz)) {
            return whereParams.getValue();
        }
        if (Integer.class.equals(clazz)) {
            return whereParams.getValue();
        }
        if (Long.class.equals(clazz)) {
            return whereParams.getValue();
        }
        if (Float.class.equals(clazz)) {
            return whereParams.getValue();
        }
        if (Double.class.equals(clazz)) {
            return whereParams.getValue();
        }
        if (String.class.equals(clazz)) {
            return whereParams.getValue();
        }
        if (Boolean.class.equals(clazz)) {
            return whereParams.getValue();
        }
        if (clazz.isEnum()) {
            return whereParams.getValue();
        }
        return whereParams.getValue();
    }

    private String addQueryParameter(Object value) {
        String parameterName = "p" + this.queryParameters.size();
        this.queryParameters.put(parameterName, value);
        return parameterName;
    }

    private List<QueryToken> getCurrentWhereTokens() {
        if (!this._isInMoreLikeThis) {
            return this.whereTokens;
        }
        if (this.whereTokens.isEmpty()) {
            throw new IllegalStateException("Cannot get MoreLikeThisToken because there are no where token specified.");
        }
        throw new NotImplementedException("More like this");
    }

    protected void updateFieldsToFetchToken(FieldsToFetchToken fieldsToFetch) {
        this.fieldsToFetchToken = fieldsToFetch;
        if (this.selectTokens.isEmpty()) {
            this.selectTokens.add(fieldsToFetch);
        } else {
            Optional<QueryToken> fetchToken = this.selectTokens.stream().filter(x -> x instanceof FieldsToFetchToken).findFirst();
            if (fetchToken.isPresent()) {
                int idx = this.selectTokens.indexOf(fetchToken.get());
                this.selectTokens.set(idx, fieldsToFetch);
            } else {
                this.selectTokens.add(fieldsToFetch);
            }
        }
    }

    public QueryOperation getQueryOperation() {
        return this.queryOperation;
    }

    public void _addBeforeQueryExecutedListener(Consumer<IndexQuery> action) {
        this.beforeQueryExecutedCallback.add(action);
    }

    public void _removeBeforeQueryExecutedListener(Consumer<IndexQuery> action) {
        this.beforeQueryExecutedCallback.remove(action);
    }

    public void _addAfterQueryExecutedListener(Consumer<QueryResult> action) {
        this.afterQueryExecutedCallback.add(action);
    }

    public void _removeAfterQueryExecutedListener(Consumer<QueryResult> action) {
        this.afterQueryExecutedCallback.remove(action);
    }

    public void _noTracking() {
        this.disableEntitiesTracking = true;
    }

    public void _noCaching() {
        this.disableCaching = true;
    }

    protected void _withinRadiusOf(String fieldName, double radius, double latitude, double longitude, SpatialUnits radiusUnits, double distErrorPercent) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        WhereToken whereToken = WhereToken.create(WhereOperator.SPATIAL_WITHIN, fieldName, null, new WhereToken.WhereOptions(ShapeToken.circle(this.addQueryParameter(radius), this.addQueryParameter(latitude), this.addQueryParameter(longitude), radiusUnits), distErrorPercent));
        tokens.add(whereToken);
    }

    protected void _spatial(String fieldName, String shapeWkt, SpatialRelation relation, double distErrorPercent) {
        WhereOperator whereOperator;
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        ShapeToken wktToken = ShapeToken.wkt(this.addQueryParameter(shapeWkt));
        switch (relation) {
            case WITHIN: {
                whereOperator = WhereOperator.SPATIAL_WITHIN;
                break;
            }
            case CONTAINS: {
                whereOperator = WhereOperator.SPATIAL_CONTAINS;
                break;
            }
            case DISJOINT: {
                whereOperator = WhereOperator.SPATIAL_DISJOINT;
                break;
            }
            case INTERSECTS: {
                whereOperator = WhereOperator.SPATIAL_INTERSECTS;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        tokens.add(WhereToken.create(whereOperator, fieldName, null, new WhereToken.WhereOptions(wktToken, distErrorPercent)));
    }

    @Override
    public void _spatial(DynamicSpatialField dynamicField, SpatialCriteria criteria) {
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, null);
        tokens.add(criteria.toQueryToken(dynamicField.toField(this::ensureValidFieldName), this::addQueryParameter));
    }

    @Override
    public void _spatial(String fieldName, SpatialCriteria criteria) {
        fieldName = this.ensureValidFieldName(fieldName, false);
        List<QueryToken> tokens = this.getCurrentWhereTokens();
        this.appendOperatorIfNeeded(tokens);
        this.negateIfNeeded(tokens, fieldName);
        tokens.add(criteria.toQueryToken(fieldName, this::addQueryParameter));
    }

    @Override
    public void _orderByDistance(DynamicSpatialField field, double latitude, double longitude) {
        if (field == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        this._orderByDistance("'" + field.toField(this::ensureValidFieldName) + "'", latitude, longitude);
    }

    @Override
    public void _orderByDistance(String fieldName, double latitude, double longitude) {
        this.orderByTokens.add(OrderByToken.createDistanceAscending(fieldName, this.addQueryParameter(latitude), this.addQueryParameter(longitude)));
    }

    @Override
    public void _orderByDistance(DynamicSpatialField field, String shapeWkt) {
        if (field == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        this._orderByDistance("'" + field.toField(this::ensureValidFieldName) + "'", shapeWkt);
    }

    @Override
    public void _orderByDistance(String fieldName, String shapeWkt) {
        this.orderByTokens.add(OrderByToken.createDistanceAscending(fieldName, this.addQueryParameter(shapeWkt)));
    }

    @Override
    public void _orderByDistanceDescending(DynamicSpatialField field, double latitude, double longitude) {
        if (field == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        this._orderByDistanceDescending("'" + field.toField(this::ensureValidFieldName) + "'", latitude, longitude);
    }

    @Override
    public void _orderByDistanceDescending(String fieldName, double latitude, double longitude) {
        this.orderByTokens.add(OrderByToken.createDistanceDescending(fieldName, this.addQueryParameter(latitude), this.addQueryParameter(longitude)));
    }

    @Override
    public void _orderByDistanceDescending(DynamicSpatialField field, String shapeWkt) {
        if (field == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        this._orderByDistanceDescending("'" + field.toField(this::ensureValidFieldName) + "'", shapeWkt);
    }

    @Override
    public void _orderByDistanceDescending(String fieldName, String shapeWkt) {
        this.orderByTokens.add(OrderByToken.createDistanceDescending(fieldName, this.addQueryParameter(shapeWkt)));
    }

    protected void initSync() {
        if (this.queryOperation != null) {
            return;
        }
        BeforeQueryExecutedEventArgs beforeQueryExecutedEventArgs = new BeforeQueryExecutedEventArgs(this.theSession);
        this.theSession.onBeforeQueryExecutedInvoke(beforeQueryExecutedEventArgs);
        this.queryOperation = this.initializeQueryOperation();
        this.executeActualQuery();
    }

    private void executeActualQuery() {
        try (CleanCloseable context = this.queryOperation.enterQueryContext();){
            QueryCommand command = this.queryOperation.createRequest();
            this.theSession.getRequestExecutor().execute(command);
            this.queryOperation.setResult((QueryResult)command.getResult());
        }
        this.invokeAfterQueryExecuted(this.queryOperation.getCurrentQueryResults());
    }

    @Override
    public Iterator<T> iterator() {
        this.initSync();
        return this.queryOperation.complete(this.clazz).iterator();
    }

    public List<T> toList() {
        return EnumerableUtils.toList(this.iterator());
    }

    public QueryResult getQueryResult() {
        this.initSync();
        return this.queryOperation.getCurrentQueryResults().createSnapshot();
    }

    public T first() {
        Collection<T> result = this.executeQueryOperation(1);
        return result.isEmpty() ? null : (T)result.stream().findFirst().get();
    }

    public T firstOrDefault() {
        Collection<T> result = this.executeQueryOperation(1);
        return (T)result.stream().findFirst().orElseGet(() -> Defaults.defaultValue(this.clazz));
    }

    public T single() {
        Collection<T> result = this.executeQueryOperation(2);
        if (result.size() > 1) {
            throw new IllegalStateException("Expected single result, got: " + result.size());
        }
        return result.stream().findFirst().orElse(null);
    }

    public T singleOrDefault() {
        Collection<T> result = this.executeQueryOperation(2);
        if (result.size() > 1) {
            throw new IllegalStateException("Expected single result, got: " + result.size());
        }
        if (result.isEmpty()) {
            return (T)Defaults.defaultValue(this.clazz);
        }
        return result.stream().findFirst().get();
    }

    public int count() {
        this._take(0);
        QueryResult queryResult = this.getQueryResult();
        return queryResult.getTotalResults();
    }

    private Collection<T> executeQueryOperation(int take) {
        if (this.pageSize == null || this.pageSize > take) {
            this._take(take);
        }
        this.initSync();
        return this.queryOperation.complete(this.clazz);
    }
}

