/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.ravendb.client.documents.session.IMetadataDictionary;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;

public class DocumentInfo {
    private String id;
    private String changeVector;
    private InMemoryDocumentSessionOperations.ConcurrencyCheckMode concurrencyCheckMode;
    private boolean ignoreChanges;
    private ObjectNode metadata;
    private ObjectNode document;
    private IMetadataDictionary metadataInstance;
    private Object entity;
    private boolean newDocument;
    private String collection;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getChangeVector() {
        return this.changeVector;
    }

    public void setChangeVector(String changeVector) {
        this.changeVector = changeVector;
    }

    public boolean isIgnoreChanges() {
        return this.ignoreChanges;
    }

    public void setIgnoreChanges(boolean ignoreChanges) {
        this.ignoreChanges = ignoreChanges;
    }

    public ObjectNode getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectNode metadata) {
        this.metadata = metadata;
    }

    public ObjectNode getDocument() {
        return this.document;
    }

    public void setDocument(ObjectNode document) {
        this.document = document;
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public boolean isNewDocument() {
        return this.newDocument;
    }

    public void setNewDocument(boolean newDocument) {
        this.newDocument = newDocument;
    }

    public String getCollection() {
        return this.collection;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public IMetadataDictionary getMetadataInstance() {
        return this.metadataInstance;
    }

    public void setMetadataInstance(IMetadataDictionary metadataInstance) {
        this.metadataInstance = metadataInstance;
    }

    public InMemoryDocumentSessionOperations.ConcurrencyCheckMode getConcurrencyCheckMode() {
        return this.concurrencyCheckMode;
    }

    public void setConcurrencyCheckMode(InMemoryDocumentSessionOperations.ConcurrencyCheckMode concurrencyCheckMode) {
        this.concurrencyCheckMode = concurrencyCheckMode;
    }

    public static DocumentInfo getNewDocumentInfo(ObjectNode document) {
        JsonNode metadata = document.get("@metadata");
        JsonNode id = metadata.get("@id");
        JsonNode changeVector = metadata.get("@change-vector");
        if (metadata == null || !metadata.isObject()) {
            throw new IllegalStateException("Document must have a metadata");
        }
        if (id == null || !id.isTextual()) {
            throw new IllegalStateException("Document must have an id");
        }
        if (changeVector == null || !changeVector.isTextual()) {
            throw new IllegalStateException("Document " + id.asText() + " must have a Change Vector");
        }
        DocumentInfo newDocumentInfo = new DocumentInfo();
        newDocumentInfo.setId(id.asText());
        newDocumentInfo.setDocument(document);
        newDocumentInfo.setMetadata((ObjectNode)metadata);
        newDocumentInfo.setEntity(null);
        newDocumentInfo.setChangeVector(changeVector.asText());
        return newDocumentInfo;
    }
}

