/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.session.DocumentInfo;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import net.ravendb.client.extensions.JsonExtensions;

public class EntityToJson {
    private final InMemoryDocumentSessionOperations _session;
    private final Map<Object, Map<String, Object>> missingDictionary = new TreeMap<Object, Map<String, Object>>((o1, o2) -> o1 == o2 ? 0 : 1);

    public EntityToJson(InMemoryDocumentSessionOperations _session) {
        this._session = _session;
    }

    public Map<Object, Map<String, Object>> getMissingDictionary() {
        return this.missingDictionary;
    }

    public ObjectNode convertEntityToJson(Object entity, DocumentInfo documentInfo) {
        if (entity instanceof ObjectNode) {
            return (ObjectNode)entity;
        }
        ObjectMapper mapper = this._session.getConventions().getEntityMapper();
        ObjectNode jsonNode = (ObjectNode)mapper.valueToTree(entity);
        EntityToJson.writeMetadata(mapper, jsonNode, documentInfo);
        Class<?> clazz = entity.getClass();
        EntityToJson.tryRemoveIdentityProperty(jsonNode, clazz, this._session.getConventions());
        return jsonNode;
    }

    public static ObjectNode convertEntityToJson(Object entity, DocumentConventions conventions) {
        return EntityToJson.convertEntityToJson(entity, conventions, null);
    }

    public static ObjectNode convertEntityToJson(Object entity, DocumentConventions conventions, DocumentInfo documentInfo) {
        if (entity instanceof ObjectNode) {
            return (ObjectNode)entity;
        }
        ObjectMapper mapper = JsonExtensions.getDefaultMapper();
        ObjectNode jsonNode = (ObjectNode)mapper.valueToTree(entity);
        EntityToJson.writeMetadata(mapper, jsonNode, documentInfo);
        Class<?> clazz = entity.getClass();
        EntityToJson.tryRemoveIdentityProperty(jsonNode, clazz, conventions);
        return jsonNode;
    }

    private static void writeMetadata(ObjectMapper mapper, ObjectNode jsonNode, DocumentInfo documentInfo) {
        if (documentInfo == null) {
            return;
        }
        boolean setMetadata = false;
        ObjectNode metadataNode = mapper.createObjectNode();
        if (documentInfo.getMetadata() != null && documentInfo.getMetadata().size() > 0) {
            setMetadata = true;
            documentInfo.getMetadata().fieldNames().forEachRemaining(property -> metadataNode.set(property, documentInfo.getMetadata().get(property).deepCopy()));
        }
        if (documentInfo.getCollection() != null) {
            setMetadata = true;
            metadataNode.set("@collection", mapper.valueToTree((Object)documentInfo.getCollection()));
        }
        if (setMetadata) {
            jsonNode.set("@metadata", (JsonNode)metadataNode);
        }
    }

    public Object convertToEntity(Class entityType, String id, ObjectNode document) {
        try {
            Class<?> type;
            Object defaultValue;
            if (ObjectNode.class.equals((Object)entityType)) {
                return document;
            }
            Object entity = defaultValue = InMemoryDocumentSessionOperations.getDefaultValue(entityType);
            String documentType = this._session.getConventions().getJavaClass(id, document);
            if (documentType != null && entityType.isAssignableFrom(type = Class.forName(documentType))) {
                entity = this._session.getConventions().getEntityMapper().treeToValue((TreeNode)document, type);
            }
            if (entity == defaultValue) {
                entity = this._session.getConventions().getEntityMapper().treeToValue((TreeNode)document, entityType);
            }
            if (id != null) {
                this._session.getGenerateEntityIdOnTheClient().trySetIdentity(entity, id);
            }
            return entity;
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not convert document " + id + " to entity of type " + entityType.getName(), e);
        }
    }

    private static boolean tryRemoveIdentityProperty(ObjectNode document, Class entityType, DocumentConventions conventions) {
        Field identityProperty = conventions.getIdentityProperty(entityType);
        if (identityProperty == null) {
            return false;
        }
        document.remove(identityProperty.getName());
        return true;
    }
}

