/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session;

import net.ravendb.client.documents.session.DocumentQuery;
import net.ravendb.client.documents.session.GroupByField;
import net.ravendb.client.documents.session.IDocumentQuery;
import net.ravendb.client.documents.session.IGroupByDocumentQuery;

public class GroupByDocumentQuery<T>
implements IGroupByDocumentQuery<T> {
    private final DocumentQuery<T> _query;

    public GroupByDocumentQuery(DocumentQuery<T> query) {
        this._query = query;
    }

    @Override
    public IGroupByDocumentQuery<T> selectKey() {
        return this.selectKey(null, null);
    }

    @Override
    public IGroupByDocumentQuery<T> selectKey(String fieldName) {
        return this.selectKey(fieldName, null);
    }

    @Override
    public IGroupByDocumentQuery<T> selectKey(String fieldName, String projectedName) {
        this._query._groupByKey(fieldName, projectedName);
        return this;
    }

    @Override
    public IDocumentQuery<T> selectSum(GroupByField field, GroupByField ... fields) {
        if (field == null) {
            throw new IllegalArgumentException("Field cannot be null");
        }
        this._query._groupBySum(field.getFieldName(), field.getProjectedName());
        if (fields == null || fields.length == 0) {
            return this._query;
        }
        for (GroupByField f : fields) {
            this._query._groupBySum(f.getFieldName(), f.getProjectedName());
        }
        return this._query;
    }

    @Override
    public IDocumentQuery<T> selectCount() {
        return this.selectCount("count");
    }

    @Override
    public IDocumentQuery<T> selectCount(String projectedName) {
        this._query._groupByCount(projectedName);
        return this._query;
    }
}

