/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session.operations;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.google.common.base.Defaults;
import com.google.common.base.Stopwatch;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ravendb.client.Parameters;
import net.ravendb.client.documents.commands.QueryCommand;
import net.ravendb.client.documents.queries.IndexQuery;
import net.ravendb.client.documents.queries.QueryResult;
import net.ravendb.client.documents.session.InMemoryDocumentSessionOperations;
import net.ravendb.client.documents.session.tokens.FieldsToFetchToken;
import net.ravendb.client.exceptions.TimeoutException;
import net.ravendb.client.exceptions.documents.indexes.IndexDoesNotExistException;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.primitives.CleanCloseable;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryOperation {
    private final InMemoryDocumentSessionOperations _session;
    private final String _indexName;
    private final IndexQuery _indexQuery;
    private final boolean _metadataOnly;
    private final boolean _indexEntriesOnly;
    private QueryResult _currentQueryResults;
    private final FieldsToFetchToken _fieldsToFetch;
    private Stopwatch _sp;
    private boolean _disableEntitiesTracking;
    private static final Log logger = LogFactory.getLog(QueryOperation.class);

    public QueryOperation(InMemoryDocumentSessionOperations session, String indexName, IndexQuery indexQuery, FieldsToFetchToken fieldsToFetch, boolean disableEntitiesTracking, boolean metadataOnly, boolean indexEntriesOnly) {
        this._session = session;
        this._indexName = indexName;
        this._indexQuery = indexQuery;
        this._fieldsToFetch = fieldsToFetch;
        this._disableEntitiesTracking = disableEntitiesTracking;
        this._metadataOnly = metadataOnly;
        this._indexEntriesOnly = indexEntriesOnly;
        this.assertPageSizeSet();
    }

    public QueryCommand createRequest() {
        this._session.incrementRequestCount();
        this.logQuery();
        return new QueryCommand(this._session.getConventions(), this._indexQuery, this._metadataOnly, this._indexEntriesOnly);
    }

    public QueryResult getCurrentQueryResults() {
        return this._currentQueryResults;
    }

    public void setResult(QueryResult queryResult) {
        this.ensureIsAcceptableAndSaveResult(queryResult);
    }

    private void assertPageSizeSet() {
        if (!this._session.getConventions().isThrowIfQueryPageSizeIsNotSet()) {
            return;
        }
        if (this._indexQuery.isPageSizeSet()) {
            return;
        }
        throw new IllegalStateException("Attempt to query without explicitly specifying a page size. You can use .take() methods to set maximum number of results. By default the page size is set to Integer.MAX_VALUE and can cause severe performance degradation.");
    }

    private void startTiming() {
        this._sp = Stopwatch.createStarted();
    }

    public void logQuery() {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("Executing query " + this._indexQuery.getQuery() + " on index " + this._indexName + " in " + this._session.storeIdentifier()));
        }
    }

    public CleanCloseable enterQueryContext() {
        this.startTiming();
        if (!this._indexQuery.isWaitForNonStaleResults()) {
            return null;
        }
        return this._session.getDocumentStore().disableAggressiveCaching(this._session.getDatabaseName());
    }

    public <T> List<T> complete(Class<T> clazz) {
        QueryResult queryResult = this._currentQueryResults.createSnapshot();
        if (!this._disableEntitiesTracking) {
            this._session.registerIncludes((ObjectNode)queryResult.getIncludes());
        }
        ArrayList<T> list = new ArrayList<T>();
        try {
            for (JsonNode document : (ArrayNode)queryResult.getResults()) {
                ObjectNode metadata = (ObjectNode)document.get("@metadata");
                JsonNode idNode = metadata.get("@id");
                String id = null;
                if (idNode != null && idNode.isTextual()) {
                    id = idNode.asText();
                }
                list.add(QueryOperation.deserialize(clazz, id, (ObjectNode)document, metadata, this._fieldsToFetch, this._disableEntitiesTracking, this._session));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to read json: " + e.getMessage(), e);
        }
        if (!this._disableEntitiesTracking) {
            this._session.registerMissingIncludes((ArrayNode)queryResult.getResults(), (ObjectNode)queryResult.getIncludes(), queryResult.getIncludedPaths());
        }
        return list;
    }

    static <T> T deserialize(Class<T> clazz, String id, ObjectNode document, ObjectNode metadata, FieldsToFetchToken fieldsToFetch, boolean disableEntitiesTracking, InMemoryDocumentSessionOperations session) throws JsonProcessingException {
        JsonNode value;
        Field identityProperty;
        JsonNode projection = metadata.get("@projection");
        if (projection == null || !projection.asBoolean()) {
            return (T)session.trackEntity(clazz, id, document, metadata, disableEntitiesTracking);
        }
        if (fieldsToFetch != null && fieldsToFetch.projections != null && fieldsToFetch.projections.length == 1) {
            String projectField;
            JsonNode jsonNode;
            if ((String.class.equals(clazz) || ClassUtils.isPrimitiveOrWrapper(clazz) || clazz.isEnum()) && (jsonNode = document.get(projectField = fieldsToFetch.projections[0])) != null && jsonNode instanceof ValueNode) {
                return (T)ObjectUtils.firstNonNull((Object[])new Object[]{JsonExtensions.getDefaultEntityMapper().convertValue((Object)jsonNode, clazz), Defaults.defaultValue(clazz)});
            }
            JsonNode inner = document.get(fieldsToFetch.projections[0]);
            if (inner == null) {
                return (T)Defaults.defaultValue(clazz);
            }
            if (fieldsToFetch.fieldsToFetch != null && fieldsToFetch.fieldsToFetch[0].equals(fieldsToFetch.projections[0]) && inner instanceof ObjectNode) {
                document = (ObjectNode)inner;
            }
        }
        Object result = session.getConventions().getEntityMapper().treeToValue((TreeNode)document, clazz);
        if (StringUtils.isNotEmpty((CharSequence)id) && (identityProperty = session.getConventions().getIdentityProperty(clazz)) != null && (value = document.get(identityProperty.getName())) == null) {
            session.getGenerateEntityIdOnTheClient().trySetIdentity(result, id);
        }
        return (T)result;
    }

    public boolean isDisableEntitiesTracking() {
        return this._disableEntitiesTracking;
    }

    public void setDisableEntitiesTracking(boolean disableEntitiesTracking) {
        this._disableEntitiesTracking = disableEntitiesTracking;
    }

    public void ensureIsAcceptableAndSaveResult(QueryResult result) {
        if (result == null) {
            throw new IndexDoesNotExistException("Could not find index " + this._indexName);
        }
        QueryOperation.ensureIsAcceptable(result, this._indexQuery.isWaitForNonStaleResults(), this._sp, this._session);
        this._currentQueryResults = result;
        if (logger.isInfoEnabled()) {
            String isStale = result.isStale() ? " stale " : " ";
            StringBuilder parameters = new StringBuilder();
            if (this._indexQuery.getQueryParameters() != null && !((Parameters)this._indexQuery.getQueryParameters()).isEmpty()) {
                parameters.append("(parameters: ");
                boolean first = true;
                for (Map.Entry parameter : ((Parameters)this._indexQuery.getQueryParameters()).entrySet()) {
                    if (!first) {
                        parameters.append(", ");
                    }
                    parameters.append((String)parameter.getKey()).append(" = ").append(parameter.getValue());
                    first = false;
                }
                parameters.append(") ");
            }
            logger.info((Object)("Query " + this._indexQuery.getQuery() + " " + parameters.toString() + "returned " + ((ArrayNode)result.getResults()).size() + isStale + "results (total index results: " + result.getTotalResults() + ")"));
        }
    }

    public static void ensureIsAcceptable(QueryResult result, boolean waitForNonStaleResults, Stopwatch duration, InMemoryDocumentSessionOperations session) {
        if (waitForNonStaleResults && result.isStale()) {
            duration.stop();
            String msg = "Waited for " + duration.toString() + " for the query to return non stale result.";
            throw new TimeoutException(msg);
        }
    }

    public IndexQuery getIndexQuery() {
        return this._indexQuery;
    }
}

