/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session.tokens;

import net.ravendb.client.documents.session.OrderingType;
import net.ravendb.client.documents.session.tokens.QueryToken;

public class OrderByToken
extends QueryToken {
    private final String _fieldName;
    private final boolean _descending;
    private final OrderingType _ordering;
    public static final OrderByToken random = new OrderByToken("random()", false, OrderingType.STRING);
    public static final OrderByToken scoreAscending = new OrderByToken("score()", false, OrderingType.STRING);
    public static final OrderByToken scoreDescending = new OrderByToken("score()", true, OrderingType.STRING);

    private OrderByToken(String fieldName, boolean descending, OrderingType ordering) {
        this._fieldName = fieldName;
        this._descending = descending;
        this._ordering = ordering;
    }

    public static OrderByToken createDistanceAscending(String fieldName, String latitudeParameterName, String longitudeParameterName) {
        return new OrderByToken("spatial.distance(" + fieldName + ", spatial.point($" + latitudeParameterName + ", $" + longitudeParameterName + "))", false, OrderingType.STRING);
    }

    public static OrderByToken createDistanceAscending(String fieldName, String shapeWktParameterName) {
        return new OrderByToken("spatial.distance(" + fieldName + ", spatial.wkt($" + shapeWktParameterName + "))", false, OrderingType.STRING);
    }

    public static OrderByToken createDistanceDescending(String fieldName, String latitudeParameterName, String longitudeParameterName) {
        return new OrderByToken("spatial.distance(" + fieldName + ", spatial.point($" + latitudeParameterName + ", $" + longitudeParameterName + "))", true, OrderingType.STRING);
    }

    public static OrderByToken createDistanceDescending(String fieldName, String shapeWktParameterName) {
        return new OrderByToken("spatial.distance(" + fieldName + ", spatial.wkt($" + shapeWktParameterName + "))", true, OrderingType.STRING);
    }

    public static OrderByToken createRandom(String seed) {
        if (seed == null) {
            throw new IllegalArgumentException("seed cannot be null");
        }
        return new OrderByToken("random('" + seed.replaceAll("'", "''") + "')", false, OrderingType.STRING);
    }

    public static OrderByToken createAscending(String fieldName, OrderingType ordering) {
        return new OrderByToken(fieldName, false, ordering);
    }

    public static OrderByToken createDescending(String fieldName, OrderingType ordering) {
        return new OrderByToken(fieldName, true, ordering);
    }

    @Override
    public void writeTo(StringBuilder writer) {
        this.writeField(writer, this._fieldName);
        switch (this._ordering) {
            case LONG: {
                writer.append(" as long");
                break;
            }
            case DOUBLE: {
                writer.append(" as double");
                break;
            }
            case ALPHA_NUMERIC: {
                writer.append(" as alphaNumeric");
            }
        }
        if (this._descending) {
            writer.append(" desc");
        }
    }
}

