/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.documents.session.tokens;

import net.ravendb.client.documents.queries.SearchOperator;
import net.ravendb.client.documents.session.tokens.QueryToken;
import net.ravendb.client.documents.session.tokens.ShapeToken;
import net.ravendb.client.documents.session.tokens.WhereOperator;
import net.ravendb.client.primitives.UseSharpEnum;
import org.apache.commons.lang3.ObjectUtils;

public class WhereToken
extends QueryToken {
    private String fieldName;
    private WhereOperator whereOperator;
    private String parameterName;
    private WhereOptions options;

    private WhereToken() {
    }

    public static WhereToken create(WhereOperator op, String fieldName, String parameterName) {
        return WhereToken.create(op, fieldName, parameterName, null);
    }

    public static WhereToken create(WhereOperator op, String fieldName, String parameterName, WhereOptions options) {
        WhereToken token = new WhereToken();
        token.fieldName = fieldName;
        token.parameterName = parameterName;
        token.whereOperator = op;
        token.options = (WhereOptions)ObjectUtils.firstNonNull((Object[])new WhereOptions[]{options, WhereOptions.defaultOptions()});
        return token;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public WhereOperator getWhereOperator() {
        return this.whereOperator;
    }

    public void setWhereOperator(WhereOperator whereOperator) {
        this.whereOperator = whereOperator;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public void setParameterName(String parameterName) {
        this.parameterName = parameterName;
    }

    public WhereOptions getOptions() {
        return this.options;
    }

    public void setOptions(WhereOptions options) {
        this.options = options;
    }

    public void addAlias(String alias) {
        if ("id()".equals(this.fieldName)) {
            return;
        }
        this.fieldName = alias + "." + this.fieldName;
    }

    private boolean writeMethod(StringBuilder writer) {
        if (this.options.getMethod() != null) {
            switch (this.options.getMethod().methodType) {
                case CMP_X_CHG: {
                    writer.append("cmpxchg(");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported method: " + (Object)((Object)this.options.getMethod().methodType));
                }
            }
            boolean first = true;
            for (String parameter : this.options.getMethod().parameters) {
                if (!first) {
                    writer.append(",");
                }
                first = false;
                writer.append("$");
                writer.append(parameter);
            }
            writer.append(")");
            if (this.options.getMethod().property != null) {
                writer.append(".").append(this.options.getMethod().property);
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeTo(StringBuilder writer) {
        if (this.options.boost != null) {
            writer.append("boost(");
        }
        if (this.options.fuzzy != null) {
            writer.append("fuzzy(");
        }
        if (this.options.proximity != null) {
            writer.append("proximity(");
        }
        if (this.options.exact) {
            writer.append("exact(");
        }
        switch (this.whereOperator) {
            case SEARCH: {
                writer.append("search(");
                break;
            }
            case LUCENE: {
                writer.append("lucene(");
                break;
            }
            case STARTS_WITH: {
                writer.append("startsWith(");
                break;
            }
            case ENDS_WITH: {
                writer.append("endsWith(");
                break;
            }
            case EXISTS: {
                writer.append("exists(");
                break;
            }
            case SPATIAL_WITHIN: {
                writer.append("spatial.within(");
                break;
            }
            case SPATIAL_CONTAINS: {
                writer.append("spatial.contains(");
                break;
            }
            case SPATIAL_DISJOINT: {
                writer.append("spatial.disjoint(");
                break;
            }
            case SPATIAL_INTERSECTS: {
                writer.append("spatial.intersects(");
                break;
            }
            case REGEX: {
                writer.append("regex(");
            }
        }
        this.writeInnerWhere(writer);
        if (this.options.exact) {
            writer.append(")");
        }
        if (this.options.proximity != null) {
            writer.append(", ").append(this.options.proximity).append(")");
        }
        if (this.options.fuzzy != null) {
            writer.append(", ").append(this.options.fuzzy).append(")");
        }
        if (this.options.boost != null) {
            writer.append(", ").append(this.options.boost).append(")");
        }
    }

    private void writeInnerWhere(StringBuilder writer) {
        this.writeField(writer, this.fieldName);
        switch (this.whereOperator) {
            case EQUALS: {
                writer.append(" = ");
                break;
            }
            case NOT_EQUALS: {
                writer.append(" != ");
                break;
            }
            case GREATER_THAN: {
                writer.append(" > ");
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                writer.append(" >= ");
                break;
            }
            case LESS_THAN: {
                writer.append(" < ");
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                writer.append(" <= ");
                break;
            }
            default: {
                this.specialOperator(writer);
                return;
            }
        }
        if (!this.writeMethod(writer)) {
            writer.append("$").append(this.parameterName);
        }
    }

    private void specialOperator(StringBuilder writer) {
        switch (this.whereOperator) {
            case IN: {
                writer.append(" in ($").append(this.parameterName).append(")");
                break;
            }
            case ALL_IN: {
                writer.append(" all in ($").append(this.parameterName).append(")");
                break;
            }
            case BETWEEN: {
                writer.append(" between $").append(this.options.fromParameterName).append(" and $").append(this.options.toParameterName);
                break;
            }
            case SEARCH: {
                writer.append(", $").append(this.parameterName);
                if (this.options.searchOperator == SearchOperator.AND) {
                    writer.append(", and");
                }
                writer.append(")");
                break;
            }
            case LUCENE: 
            case STARTS_WITH: 
            case ENDS_WITH: 
            case REGEX: {
                writer.append(", $").append(this.parameterName).append(")");
                break;
            }
            case EXISTS: {
                writer.append(")");
                break;
            }
            case SPATIAL_WITHIN: 
            case SPATIAL_CONTAINS: 
            case SPATIAL_DISJOINT: 
            case SPATIAL_INTERSECTS: {
                writer.append(", ");
                this.options.whereShape.writeTo(writer);
                if (Math.abs(this.options.distanceErrorPct - 0.025) > 1.0E-40) {
                    writer.append(", ");
                    writer.append(this.options.distanceErrorPct);
                }
                writer.append(")");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public static class WhereOptions {
        private SearchOperator searchOperator;
        private String fromParameterName;
        private String toParameterName;
        private Double boost;
        private Double fuzzy;
        private Integer proximity;
        private boolean exact;
        private WhereMethodCall method;
        private ShapeToken whereShape;
        private double distanceErrorPct;

        public static WhereOptions defaultOptions() {
            return new WhereOptions();
        }

        private WhereOptions() {
        }

        public WhereOptions(boolean exact) {
            this.exact = exact;
        }

        public WhereOptions(boolean exact, String from, String to) {
            this.exact = exact;
            this.fromParameterName = from;
            this.toParameterName = to;
        }

        public WhereOptions(SearchOperator search) {
            this.searchOperator = search;
        }

        public WhereOptions(ShapeToken shape, double distance) {
            this.whereShape = shape;
            this.distanceErrorPct = distance;
        }

        public WhereOptions(MethodsType methodType, String[] parameters, String property) {
            this(methodType, parameters, property, false);
        }

        public WhereOptions(MethodsType methodType, String[] parameters, String property, boolean exact) {
            this.method = new WhereMethodCall();
            this.method.methodType = methodType;
            this.method.parameters = parameters;
            this.method.property = property;
            this.exact = exact;
        }

        public SearchOperator getSearchOperator() {
            return this.searchOperator;
        }

        public void setSearchOperator(SearchOperator searchOperator) {
            this.searchOperator = searchOperator;
        }

        public String getFromParameterName() {
            return this.fromParameterName;
        }

        public void setFromParameterName(String fromParameterName) {
            this.fromParameterName = fromParameterName;
        }

        public String getToParameterName() {
            return this.toParameterName;
        }

        public void setToParameterName(String toParameterName) {
            this.toParameterName = toParameterName;
        }

        public Double getBoost() {
            return this.boost;
        }

        public void setBoost(Double boost) {
            this.boost = boost;
        }

        public Double getFuzzy() {
            return this.fuzzy;
        }

        public void setFuzzy(Double fuzzy) {
            this.fuzzy = fuzzy;
        }

        public Integer getProximity() {
            return this.proximity;
        }

        public void setProximity(Integer proximity) {
            this.proximity = proximity;
        }

        public boolean isExact() {
            return this.exact;
        }

        public void setExact(boolean exact) {
            this.exact = exact;
        }

        public WhereMethodCall getMethod() {
            return this.method;
        }

        public void setMethod(WhereMethodCall method) {
            this.method = method;
        }

        public ShapeToken getWhereShape() {
            return this.whereShape;
        }

        public void setWhereShape(ShapeToken whereShape) {
            this.whereShape = whereShape;
        }

        public double getDistanceErrorPct() {
            return this.distanceErrorPct;
        }

        public void setDistanceErrorPct(double distanceErrorPct) {
            this.distanceErrorPct = distanceErrorPct;
        }
    }

    public static class WhereMethodCall {
        public MethodsType methodType;
        public String[] parameters;
        public String property;
    }

    @UseSharpEnum
    public static enum MethodsType {
        CMP_X_CHG;

    }
}

