/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.exceptions;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import net.ravendb.client.exceptions.ConcurrencyException;
import net.ravendb.client.exceptions.RavenException;
import net.ravendb.client.exceptions.documents.DocumentConflictException;
import net.ravendb.client.exceptions.documents.compilation.IndexCompilationException;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.RequestExecutor;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;

public class ExceptionDispatcher {
    public static RavenException get(ExceptionSchema schema, int code) {
        return ExceptionDispatcher.get(schema.getMessage(), schema.getError(), schema.getType(), code);
    }

    public static RavenException get(String message, String error, String typeAsString, int code) {
        RavenException exception;
        if (code == 409) {
            if (typeAsString.contains("DocumentConflictException")) {
                return DocumentConflictException.fromMessage(message);
            }
            return new ConcurrencyException(message);
        }
        Class<?> type = ExceptionDispatcher.getType(typeAsString);
        if (type == null) {
            return new RavenException(error);
        }
        try {
            exception = (RavenException)type.getConstructor(String.class).newInstance(error);
        }
        catch (Exception e) {
            return new RavenException(error);
        }
        if (!RavenException.class.isAssignableFrom(type)) {
            return new RavenException(error, exception);
        }
        return exception;
    }

    public static void throwException(CloseableHttpResponse response) {
        if (response == null) {
            throw new IllegalArgumentException("Response cannot be null");
        }
        try {
            try {
                RavenException exception;
                Class<?> type;
                InputStream stream = RequestExecutor.readAsStream(response);
                String json = IOUtils.toString((InputStream)stream, (String)"UTF-8");
                ExceptionSchema schema = (ExceptionSchema)JsonExtensions.getDefaultMapper().readValue(json, ExceptionSchema.class);
                if (response.getStatusLine().getStatusCode() == 409) {
                    ExceptionDispatcher.throwConflict(schema, json);
                }
                if ((type = ExceptionDispatcher.getType(schema.getType())) == null) {
                    throw RavenException.generic(schema.getError(), json);
                }
                try {
                    exception = (RavenException)type.getConstructor(String.class).newInstance(schema.getError());
                }
                catch (Exception e) {
                    throw RavenException.generic(schema.getError(), json);
                }
                if (!RavenException.class.isAssignableFrom(type)) {
                    throw new RavenException(schema.getError(), exception);
                }
                if (IndexCompilationException.class.equals(type)) {
                    JsonNode problematicText;
                    IndexCompilationException indexCompilationException = (IndexCompilationException)exception;
                    JsonNode jsonNode = JsonExtensions.getDefaultMapper().readTree(json);
                    JsonNode indexDefinitionProperty = jsonNode.get("TransformerDefinitionProperty");
                    if (indexDefinitionProperty != null) {
                        indexCompilationException.setIndexDefinitionProperty(indexDefinitionProperty.asText());
                    }
                    if ((problematicText = jsonNode.get("ProblematicText")) != null) {
                        indexCompilationException.setProblematicText(problematicText.asText());
                    }
                    throw indexCompilationException;
                }
                throw exception;
            }
            catch (IOException e) {
                throw new RavenException(e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Closeable)response);
            throw throwable;
        }
    }

    private static void throwConflict(ExceptionSchema schema, String json) {
        if (schema.getType().contains("DocumentConflictException")) {
            throw DocumentConflictException.fromJson(json);
        }
        throw new ConcurrencyException(schema.getMessage());
    }

    private static Class<?> getType(String typeAsString) {
        String prefix = "Raven.Client.Exceptions.";
        if (typeAsString.startsWith(prefix)) {
            String exceptionName = typeAsString.substring(prefix.length());
            if (exceptionName.contains(".")) {
                CharSequence[] tokens = exceptionName.split("\\.");
                for (int i = 0; i < tokens.length - 1; ++i) {
                    tokens[i] = ((String)tokens[i]).toLowerCase();
                }
                exceptionName = String.join((CharSequence)".", tokens);
            }
            try {
                return Class.forName(RavenException.class.getPackage().getName() + "." + exceptionName);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static class ExceptionSchema {
        private String url;
        private String type;
        private String message;
        private String error;

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}

