/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.extensions;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;

public class HttpExtensions {
    public static String getRequiredEtagHeader(CloseableHttpResponse response) {
        if (response.containsHeader("ETag")) {
            Header firstHeader = response.getFirstHeader("ETag");
            String value = firstHeader.getValue();
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return HttpExtensions.etagHeaderToChangeVector(value);
            }
            throw new IllegalStateException("Response did't had an ETag header");
        }
        throw new IllegalStateException("Response did't had an ETag header");
    }

    public static String getEtagHeader(CloseableHttpResponse response) {
        Header[] headers;
        if (response.containsHeader("ETag") && (headers = response.getHeaders("ETag")).length > 0) {
            return HttpExtensions.etagHeaderToChangeVector(headers[0].getValue());
        }
        return null;
    }

    private static String etagHeaderToChangeVector(String responseHeader) {
        if (StringUtils.isEmpty((CharSequence)responseHeader)) {
            throw new IllegalStateException("Response did't had an ETag header");
        }
        if (responseHeader.startsWith("\"")) {
            return responseHeader.substring(1, responseHeader.length() - 1);
        }
        return responseHeader;
    }

    public static String getEtagHeader(Map<String, String> headers) {
        if (headers.containsKey("ETag")) {
            return HttpExtensions.etagHeaderToChangeVector(headers.get("ETag"));
        }
        return null;
    }

    public static Boolean getBooleanHeader(CloseableHttpResponse response, String header) {
        if (response.containsHeader(header)) {
            Header firstHeader = response.getFirstHeader(header);
            String value = firstHeader.getValue();
            return Boolean.valueOf(value);
        }
        return null;
    }
}

