/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.http;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.time.LocalDateTime;
import net.ravendb.client.http.HttpCacheItem;
import net.ravendb.client.primitives.CleanCloseable;
import net.ravendb.client.primitives.Reference;

public class HttpCache
implements CleanCloseable {
    private Cache<String, HttpCacheItem> items;

    public HttpCache(int size) {
        this.items = CacheBuilder.newBuilder().softValues().maximumWeight((long)size).weigher((k, v) -> v.payload != null ? v.payload.length() + 20 : 20).build();
    }

    @Override
    public void close() {
        this.items.invalidateAll();
        this.items = null;
    }

    public void set(String url, String changeVector, String result) {
        HttpCacheItem httpCacheItem = new HttpCacheItem();
        httpCacheItem.changeVector = changeVector;
        httpCacheItem.payload = result;
        httpCacheItem.cache = this;
        this.items.put((Object)url, (Object)httpCacheItem);
    }

    public ReleaseCacheItem get(String url, Reference<String> changeVectorRef, Reference<String> responseRef) {
        HttpCacheItem item = (HttpCacheItem)this.items.getIfPresent((Object)url);
        if (item != null) {
            changeVectorRef.value = item.changeVector;
            responseRef.value = item.payload;
            return new ReleaseCacheItem(item);
        }
        changeVectorRef.value = null;
        responseRef.value = null;
        return new ReleaseCacheItem(null);
    }

    public void setNotFound(String url) {
        HttpCacheItem httpCacheItem = new HttpCacheItem();
        httpCacheItem.changeVector = "404 response";
        httpCacheItem.cache = this;
        this.items.put((Object)url, (Object)httpCacheItem);
    }

    public static class ReleaseCacheItem
    implements CleanCloseable {
        public final HttpCacheItem item;

        public ReleaseCacheItem(HttpCacheItem item) {
            this.item = item;
        }

        public void notModified() {
            if (this.item != null) {
                this.item.lastServerUpdate = LocalDateTime.now();
            }
        }

        public Duration getAge() {
            if (this.item == null) {
                return Duration.ofMillis(Long.MAX_VALUE);
            }
            return Duration.between(this.item.lastServerUpdate, LocalDateTime.now());
        }

        public boolean getMightHaveBeenModified() {
            return false;
        }

        @Override
        public void close() {
        }
    }
}

