/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import net.ravendb.client.extensions.HttpExtensions;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.HttpCache;
import net.ravendb.client.http.RavenCommandResponseType;
import net.ravendb.client.http.ResponseDisposeHandling;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;

public abstract class RavenCommand<TResult> {
    protected final Class<TResult> resultClass;
    protected TResult result;
    protected int statusCode;
    protected RavenCommandResponseType responseType;
    protected boolean canCache;
    protected boolean canCacheAggressively;
    protected final ObjectMapper mapper = JsonExtensions.getDefaultMapper();
    private Map<ServerNode, Exception> failedNodes;

    public abstract boolean isReadRequest();

    public RavenCommandResponseType getResponseType() {
        return this.responseType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public TResult getResult() {
        return this.result;
    }

    public void setResult(TResult result) {
        this.result = result;
    }

    public boolean canCache() {
        return this.canCache;
    }

    public boolean canCacheAggressively() {
        return this.canCacheAggressively;
    }

    protected RavenCommand(Class<TResult> resultClass) {
        this.resultClass = resultClass;
        this.responseType = RavenCommandResponseType.OBJECT;
        this.canCache = true;
        this.canCacheAggressively = true;
    }

    public abstract HttpRequestBase createRequest(ServerNode var1, Reference<String> var2);

    public void setResponse(String response, boolean fromCache) throws IOException {
        if (this.responseType == RavenCommandResponseType.EMPTY || this.responseType == RavenCommandResponseType.RAW) {
            RavenCommand.throwInvalidResponse();
        }
        throw new UnsupportedOperationException(this.responseType.name() + " command must override the setResponse method which expects response with the following type: " + (Object)((Object)this.responseType));
    }

    public CloseableHttpResponse send(CloseableHttpClient client, HttpRequestBase request) throws IOException {
        return client.execute((HttpUriRequest)request);
    }

    public void setResponseRaw(CloseableHttpResponse response, InputStream stream) {
        throw new UnsupportedOperationException("When " + (Object)((Object)this.responseType) + " is set to Raw then please override this method to handle the response. ");
    }

    public Map<ServerNode, Exception> getFailedNodes() {
        return this.failedNodes;
    }

    public void setFailedNodes(Map<ServerNode, Exception> failedNodes) {
        this.failedNodes = failedNodes;
    }

    protected String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void ensureIsNotNullOrString(String value, String name) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new IllegalArgumentException(name + " cannot be null or empty");
        }
    }

    public boolean isFailedWithNode(ServerNode node) {
        return this.failedNodes != null && this.failedNodes.containsKey(node);
    }

    public ResponseDisposeHandling processResponse(HttpCache cache, CloseableHttpResponse response, String url) {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            return ResponseDisposeHandling.AUTOMATIC;
        }
        if (this.responseType == RavenCommandResponseType.EMPTY || response.getStatusLine().getStatusCode() == 204) {
            return ResponseDisposeHandling.AUTOMATIC;
        }
        try {
            if (this.responseType == RavenCommandResponseType.OBJECT) {
                Long contentLength = entity.getContentLength();
                if (contentLength == 0L) {
                    HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
                    ResponseDisposeHandling responseDisposeHandling = ResponseDisposeHandling.AUTOMATIC;
                    return responseDisposeHandling;
                }
                String json = IOUtils.toString((InputStream)entity.getContent(), (String)"UTF-8");
                if (cache != null) {
                    this.cacheResponse(cache, url, response, json);
                }
                this.setResponse(json, false);
                ResponseDisposeHandling responseDisposeHandling = ResponseDisposeHandling.AUTOMATIC;
                return responseDisposeHandling;
            }
            this.setResponseRaw(response, entity.getContent());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            HttpClientUtils.closeQuietly((CloseableHttpResponse)response);
        }
        return ResponseDisposeHandling.AUTOMATIC;
    }

    protected void cacheResponse(HttpCache cache, String url, CloseableHttpResponse response, String responseJson) {
        if (!this.canCache()) {
            return;
        }
        String changeVector = HttpExtensions.getEtagHeader(response);
        if (changeVector == null) {
            return;
        }
        cache.set(url, changeVector, responseJson);
    }

    protected static void throwInvalidResponse() {
        throw new IllegalStateException("Response is invalid");
    }

    protected void addChangeVectorIfNotNull(String changeVector, HttpRequestBase request) {
        if (changeVector != null) {
            request.addHeader("If-Match", "\"" + changeVector + "\"");
        }
    }

    public void onResponseFailure(CloseableHttpResponse response) {
    }
}

