/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.http;

import com.google.common.base.Stopwatch;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.xml.bind.DatatypeConverter;
import net.ravendb.client.documents.commands.GetStatisticsCommand;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.configuration.GetClientConfigurationOperation;
import net.ravendb.client.documents.session.SessionInfo;
import net.ravendb.client.exceptions.AllTopologyNodesDownException;
import net.ravendb.client.exceptions.ExceptionDispatcher;
import net.ravendb.client.exceptions.RavenException;
import net.ravendb.client.exceptions.database.DatabaseDoesNotExistException;
import net.ravendb.client.exceptions.security.AuthorizationException;
import net.ravendb.client.extensions.HttpExtensions;
import net.ravendb.client.extensions.JsonExtensions;
import net.ravendb.client.http.AggressiveCacheOptions;
import net.ravendb.client.http.CurrentIndexAndNode;
import net.ravendb.client.http.HttpCache;
import net.ravendb.client.http.NodeSelector;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.RavenCommandResponseType;
import net.ravendb.client.http.ReadBalanceBehavior;
import net.ravendb.client.http.ResponseDisposeHandling;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.http.Topology;
import net.ravendb.client.primitives.CleanCloseable;
import net.ravendb.client.primitives.ExceptionsUtils;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.primitives.Timer;
import net.ravendb.client.primitives.Tuple;
import net.ravendb.client.serverwide.commands.GetTopologyCommand;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.SocketConfig;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.ssl.SSLContexts;

public class RequestExecutor
implements CleanCloseable {
    public static final Consumer<HttpClientBuilder> configureHttpClient = null;
    public static Consumer<HttpRequestBase> requestPostProcessor = null;
    public static final String CLIENT_VERSION = "4.0.0";
    private static final ConcurrentMap<String, CloseableHttpClient> globalHttpClient = new ConcurrentHashMap<String, CloseableHttpClient>();
    private final Semaphore _updateTopologySemaphore = new Semaphore(1);
    private final Semaphore _updateClientConfigurationSemaphore = new Semaphore(1);
    private final ConcurrentMap<ServerNode, NodeStatus> _failedNodesTimers = new ConcurrentHashMap<ServerNode, NodeStatus>();
    private final KeyStore certificate;
    private final String _databaseName;
    private static final Log logger = LogFactory.getLog(RequestExecutor.class);
    private Date _lastReturnedResponse;
    protected final ReadBalanceBehavior _readBalanceBehavior;
    private final HttpCache cache;
    private ServerNode topologyTakenFromNode;
    public final ThreadLocal<AggressiveCacheOptions> AggressiveCaching = new ThreadLocal();
    private final CloseableHttpClient httpClient;
    private Timer _updateTopologyTimer;
    protected NodeSelector _nodeSelector;
    public final AtomicLong numberOfServerRequests = new AtomicLong(0L);
    protected long topologyEtag;
    protected long clientConfigurationEtag;
    private final DocumentConventions conventions;
    protected boolean _disableTopologyUpdates;
    protected boolean _disableClientConfigurationUpdates;
    protected boolean _disposed;
    protected CompletableFuture<Void> _firstTopologyUpdate;
    protected String[] _lastKnownUrls;

    public HttpCache getCache() {
        return this.cache;
    }

    public Topology getTopology() {
        return this._nodeSelector != null ? this._nodeSelector.getTopology() : null;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public List<ServerNode> getTopologyNodes() {
        return Optional.ofNullable(this.getTopology()).map(Topology::getNodes).map(Collections::unmodifiableList).orElse(null);
    }

    public String getUrl() {
        if (this._nodeSelector == null) {
            return null;
        }
        CurrentIndexAndNode preferredNode = this._nodeSelector.getPreferredNode();
        return preferredNode != null ? preferredNode.currentNode.getUrl() : null;
    }

    public long getTopologyEtag() {
        return this.topologyEtag;
    }

    public long getClientConfigurationEtag() {
        return this.clientConfigurationEtag;
    }

    public DocumentConventions getConventions() {
        return this.conventions;
    }

    public KeyStore getCertificate() {
        return this.certificate;
    }

    protected RequestExecutor(String databaseName, KeyStore certificate, DocumentConventions conventions) {
        this.cache = new HttpCache(conventions.getMaxHttpCacheSize());
        this._readBalanceBehavior = conventions.getReadBalanceBehavior();
        this._databaseName = databaseName;
        this.certificate = certificate;
        this._lastReturnedResponse = new Date();
        this.conventions = conventions.clone();
        String thumbprint = "";
        if (certificate != null) {
            thumbprint = this.extractThumbprintFromCertificate(certificate);
        }
        this.httpClient = globalHttpClient.computeIfAbsent(thumbprint, thumb -> this.createClient());
    }

    private String extractThumbprintFromCertificate(KeyStore certificate) {
        try {
            ArrayList<String> aliases = Collections.list(certificate.aliases());
            if (aliases.size() != 1) {
                throw new IllegalStateException("Expected single certificate in keystore.");
            }
            String alias = aliases.get(0);
            Certificate clientCertificate = certificate.getCertificate(alias);
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(clientCertificate.getEncoded());
            return DatatypeConverter.printHexBinary((byte[])sha1);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new IllegalStateException("Unable to extract certificate thumbprint " + e.getMessage(), e);
        }
    }

    public static RequestExecutor create(String[] urls, String databaseName, KeyStore certificate, DocumentConventions conventions) {
        RequestExecutor executor = new RequestExecutor(databaseName, certificate, conventions);
        executor._firstTopologyUpdate = executor.firstTopologyUpdate(urls);
        return executor;
    }

    public static RequestExecutor createForSingleNodeWithConfigurationUpdates(String url, String databaseName, KeyStore certificate, DocumentConventions conventions) {
        RequestExecutor executor = RequestExecutor.createForSingleNodeWithoutConfigurationUpdates(url, databaseName, certificate, conventions);
        executor._disableClientConfigurationUpdates = false;
        return executor;
    }

    public static RequestExecutor createForSingleNodeWithoutConfigurationUpdates(String url, String databaseName, KeyStore certificate, DocumentConventions conventions) {
        String[] initialUrls = RequestExecutor.validateUrls(new String[]{url}, certificate);
        RequestExecutor executor = new RequestExecutor(databaseName, certificate, conventions);
        Topology topology = new Topology();
        topology.setEtag(-1L);
        ServerNode serverNode = new ServerNode();
        serverNode.setDatabase(databaseName);
        serverNode.setUrl(initialUrls[0]);
        topology.setNodes(Collections.singletonList(serverNode));
        executor._nodeSelector = new NodeSelector(topology);
        executor.topologyEtag = -2L;
        executor._disableTopologyUpdates = true;
        executor._disableClientConfigurationUpdates = true;
        return executor;
    }

    protected CompletableFuture<Void> updateClientConfigurationAsync() {
        if (this._disposed) {
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.runAsync(() -> {
            try {
                this._updateClientConfigurationSemaphore.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            boolean oldDisableClientConfigurationUpdates = this._disableClientConfigurationUpdates;
            this._disableClientConfigurationUpdates = true;
            try {
                if (this._disposed) {
                    return;
                }
                GetClientConfigurationOperation.GetClientConfigurationCommand command = new GetClientConfigurationOperation.GetClientConfigurationCommand();
                CurrentIndexAndNode currentIndexAndNode = this.chooseNodeForRequest(command, null);
                this.execute(currentIndexAndNode.currentNode, currentIndexAndNode.currentIndex, command, false, null);
                GetClientConfigurationOperation.Result result = (GetClientConfigurationOperation.Result)command.getResult();
                if (result == null) {
                    return;
                }
                this.conventions.updateFrom(result.getConfiguration());
                this.clientConfigurationEtag = result.getEtag();
            }
            finally {
                this._disableClientConfigurationUpdates = oldDisableClientConfigurationUpdates;
                this._updateClientConfigurationSemaphore.release();
            }
        });
    }

    public CompletableFuture<Boolean> updateTopologyAsync(ServerNode node, int timeout) {
        return this.updateTopologyAsync(node, timeout, false);
    }

    public CompletableFuture<Boolean> updateTopologyAsync(ServerNode node, int timeout, boolean forceUpdate) {
        if (this._disposed) {
            return CompletableFuture.completedFuture(false);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                boolean lockTaken = this._updateTopologySemaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
                if (!lockTaken) {
                    return false;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            try {
                if (this._disposed) {
                    Boolean e = false;
                    return e;
                }
                GetTopologyCommand command = new GetTopologyCommand();
                this.execute(node, null, command, false, null);
                if (this._nodeSelector == null) {
                    this._nodeSelector = new NodeSelector((Topology)command.getResult());
                    if (this._readBalanceBehavior == ReadBalanceBehavior.FASTEST_NODE) {
                        this._nodeSelector.scheduleSpeedTest();
                    }
                } else if (this._nodeSelector.onUpdateTopology((Topology)command.getResult(), forceUpdate)) {
                    this.disposeAllFailedNodesTimers();
                    if (this._readBalanceBehavior == ReadBalanceBehavior.FASTEST_NODE) {
                        this._nodeSelector.scheduleSpeedTest();
                    }
                }
                this.topologyEtag = this._nodeSelector.getTopology().getEtag();
            }
            finally {
                this._updateTopologySemaphore.release();
            }
            return true;
        });
    }

    protected void disposeAllFailedNodesTimers() {
        this._failedNodesTimers.forEach((node, status) -> status.close());
        this._failedNodesTimers.clear();
    }

    public <TResult> void execute(RavenCommand<TResult> command) {
        this.execute(command, null);
    }

    public <TResult> void execute(RavenCommand<TResult> command, SessionInfo sessionInfo) {
        CompletableFuture<Void> topologyUpdate = this._firstTopologyUpdate;
        if (topologyUpdate != null && topologyUpdate.isDone() || this._disableTopologyUpdates) {
            CurrentIndexAndNode currentIndexAndNode = this.chooseNodeForRequest(command, sessionInfo);
            this.execute(currentIndexAndNode.currentNode, currentIndexAndNode.currentIndex, command, true, sessionInfo);
            return;
        }
        this.unlikelyExecute(command, topologyUpdate, sessionInfo);
    }

    public <TResult> CurrentIndexAndNode chooseNodeForRequest(RavenCommand<TResult> cmd, SessionInfo sessionInfo) {
        if (!cmd.isReadRequest()) {
            return this._nodeSelector.getPreferredNode();
        }
        switch (this._readBalanceBehavior) {
            case NONE: {
                return this._nodeSelector.getPreferredNode();
            }
            case ROUND_ROBIN: {
                return this._nodeSelector.getNodeBySessionId(sessionInfo != null ? sessionInfo.getSessionId() : 0);
            }
            case FASTEST_NODE: {
                return this._nodeSelector.getFastestNode();
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TResult> void unlikelyExecute(RavenCommand<TResult> command, CompletableFuture<Void> topologyUpdate, SessionInfo sessionInfo) {
        try {
            if (topologyUpdate == null) {
                RequestExecutor requestExecutor = this;
                synchronized (requestExecutor) {
                    if (this._firstTopologyUpdate == null) {
                        if (this._lastKnownUrls == null) {
                            throw new IllegalStateException("No known topology and no previously known one, cannot proceed, likely a bug");
                        }
                        this._firstTopologyUpdate = this.firstTopologyUpdate(this._lastKnownUrls);
                    }
                    topologyUpdate = this._firstTopologyUpdate;
                }
            }
            topologyUpdate.get();
        }
        catch (InterruptedException | ExecutionException e) {
            RequestExecutor requestExecutor = this;
            synchronized (requestExecutor) {
                if (this._firstTopologyUpdate == topologyUpdate) {
                    this._firstTopologyUpdate = null;
                }
            }
            throw ExceptionsUtils.unwrapException(e);
        }
        CurrentIndexAndNode currentIndexAndNode = this.chooseNodeForRequest(command, sessionInfo);
        this.execute(currentIndexAndNode.currentNode, currentIndexAndNode.currentIndex, command, true, sessionInfo);
    }

    private void updateTopologyCallback() {
        ServerNode serverNode;
        Date time = new Date();
        if (time.getTime() - this._lastReturnedResponse.getTime() <= Duration.ofMinutes(5L).toMillis()) {
            return;
        }
        try {
            CurrentIndexAndNode preferredNode = this._nodeSelector.getPreferredNode();
            serverNode = preferredNode.currentNode;
        }
        catch (Exception e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Couldn't get preferred node Topology from _updateTopologyTimer", (Throwable)e);
            }
            return;
        }
        this.updateTopologyAsync(serverNode, 0).exceptionally(ex -> {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Couldn't update topology from _updateTopologyTimer", ex);
            }
            return null;
        });
    }

    protected CompletableFuture<Void> firstTopologyUpdate(String[] inputUrls) {
        String[] initialUrls = RequestExecutor.validateUrls(inputUrls, this.certificate);
        ArrayList list = new ArrayList();
        return CompletableFuture.runAsync(() -> {
            for (String url2 : initialUrls) {
                try {
                    ServerNode serverNode = new ServerNode();
                    serverNode.setUrl(url2);
                    serverNode.setDatabase(this._databaseName);
                    this.updateTopologyAsync(serverNode, Integer.MAX_VALUE).get();
                    this.initializeUpdateTopologyTimer();
                    this.topologyTakenFromNode = serverNode;
                    return;
                }
                catch (DatabaseDoesNotExistException e) {
                    this._lastKnownUrls = initialUrls;
                    throw e;
                }
                catch (Exception e) {
                    if (initialUrls.length == 0) {
                        this._lastKnownUrls = initialUrls;
                        throw new IllegalStateException("Cannot get topology from server: " + url2, e);
                    }
                    list.add(Tuple.create(url2, e));
                }
            }
            Topology topology = new Topology();
            topology.setEtag(this.topologyEtag);
            List<ServerNode> topologyNodes = this.getTopologyNodes();
            if (topologyNodes == null) {
                topologyNodes = Arrays.stream(initialUrls).map(url -> {
                    ServerNode serverNode = new ServerNode();
                    serverNode.setUrl((String)url);
                    serverNode.setDatabase(this._databaseName);
                    serverNode.setClusterTag("!");
                    return serverNode;
                }).collect(Collectors.toList());
            }
            topology.setNodes(topologyNodes);
            this._nodeSelector = new NodeSelector(topology);
            if (initialUrls != null && initialUrls.length > 0) {
                this.initializeUpdateTopologyTimer();
                return;
            }
            this._lastKnownUrls = initialUrls;
            String details = list.stream().map(x -> (String)x.first + " -> " + Optional.ofNullable(x.second).map(m -> m.getMessage()).orElse("")).collect(Collectors.joining(", "));
            this.throwExceptions(details);
        });
    }

    protected void throwExceptions(String details) {
        throw new IllegalStateException("Failed to retrieve database topology from all known nodes" + System.lineSeparator() + details);
    }

    protected static String[] validateUrls(String[] initialUrls, KeyStore certificate) {
        String[] cleanUrls = new String[initialUrls.length];
        boolean requireHttps = certificate != null;
        for (int index = 0; index < initialUrls.length; ++index) {
            String url = initialUrls[index];
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("The url '" + url + "' is not valid");
            }
            cleanUrls[index] = StringUtils.stripEnd((String)url, (String)"/");
            requireHttps |= url.startsWith("https://");
        }
        if (!requireHttps) {
            return cleanUrls;
        }
        for (String url : initialUrls) {
            if (!url.startsWith("http://")) continue;
            if (certificate != null) {
                throw new IllegalStateException("The url " + url + " is using HTTP, but a certificate is specified, which require us to use HTTPS");
            }
            throw new IllegalStateException("The url " + url + " is using HTTP, but other urls are using HTTPS, and mixing of HTTP and HTTPS is not allowed.");
        }
        return cleanUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeUpdateTopologyTimer() {
        if (this._updateTopologyTimer != null) {
            return;
        }
        RequestExecutor requestExecutor = this;
        synchronized (requestExecutor) {
            if (this._updateTopologyTimer != null) {
                return;
            }
            this._updateTopologyTimer = new Timer(this::updateTopologyCallback, Duration.ofMinutes(5L), Duration.ofMinutes(5L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TResult> void execute(ServerNode chosenNode, Integer nodeIndex, RavenCommand<TResult> command, boolean shouldRetry, SessionInfo sessionInfo) {
        block65: {
            Reference<String> urlRef = new Reference<String>();
            HttpRequestBase request = this.createRequest(chosenNode, command, urlRef);
            Reference<String> cachedChangeVector = new Reference<String>();
            Reference<String> cachedValue = new Reference<String>();
            try (HttpCache.ReleaseCacheItem cachedItem = this.getFromCache(command, (String)urlRef.value, cachedChangeVector, cachedValue);){
                Boolean refreshClientConfiguration;
                Boolean refreshTopology;
                block64: {
                    ResponseDisposeHandling responseDispose;
                    CloseableHttpResponse response;
                    block62: {
                        block63: {
                            block60: {
                                block61: {
                                    if (cachedChangeVector.value != null) {
                                        AggressiveCacheOptions aggressiveCacheOptions = this.AggressiveCaching.get();
                                        if (aggressiveCacheOptions != null && cachedItem.getAge().compareTo(aggressiveCacheOptions.getDuration()) < 0 && !cachedItem.getMightHaveBeenModified() && command.canCacheAggressively()) {
                                            try {
                                                command.setResponse((String)cachedValue.value, true);
                                            }
                                            catch (IOException e) {
                                                throw new RuntimeException(e);
                                            }
                                            return;
                                        }
                                        request.addHeader("If-None-Match", "\"" + (String)cachedChangeVector.value + "\"");
                                    }
                                    if (!this._disableClientConfigurationUpdates) {
                                        request.addHeader("Client-Configuration-Etag", "\"" + this.clientConfigurationEtag + "\"");
                                    }
                                    if (!this._disableTopologyUpdates) {
                                        request.addHeader("Topology-Etag", "\"" + this.topologyEtag + "\"");
                                    }
                                    Stopwatch sp = Stopwatch.createStarted();
                                    response = null;
                                    responseDispose = ResponseDisposeHandling.AUTOMATIC;
                                    try {
                                        this.numberOfServerRequests.incrementAndGet();
                                        response = this.shouldExecuteOnAll(chosenNode, command) ? this.executeOnAllToFigureOutTheFastest(chosenNode, command) : command.send(this.httpClient, request);
                                        sp.stop();
                                    }
                                    catch (IOException e) {
                                        if (!shouldRetry) {
                                            throw ExceptionsUtils.unwrapException(e);
                                        }
                                        sp.stop();
                                        if (!this.handleServerDown((String)urlRef.value, chosenNode, nodeIndex, command, request, response, e, sessionInfo)) {
                                            this.throwFailedToContactAllNodes(command, request, e, null);
                                        }
                                        if (cachedItem != null) {
                                            if (var11_11 != null) {
                                                try {
                                                    cachedItem.close();
                                                }
                                                catch (Throwable throwable) {
                                                    var11_11.addSuppressed(throwable);
                                                }
                                            } else {
                                                cachedItem.close();
                                            }
                                        }
                                        return;
                                    }
                                    command.statusCode = response.getStatusLine().getStatusCode();
                                    refreshTopology = Optional.ofNullable(HttpExtensions.getBooleanHeader(response, "Refresh-Topology")).orElse(false);
                                    refreshClientConfiguration = Optional.ofNullable(HttpExtensions.getBooleanHeader(response, "Refresh-Client-Configuration")).orElse(false);
                                    try {
                                        if (response.getStatusLine().getStatusCode() != 304) break block60;
                                        cachedItem.notModified();
                                        try {
                                            if (command.getResponseType() == RavenCommandResponseType.OBJECT) {
                                                command.setResponse((String)cachedValue.value, true);
                                            }
                                        }
                                        catch (IOException e) {
                                            throw ExceptionsUtils.unwrapException(e);
                                        }
                                        if (responseDispose != ResponseDisposeHandling.AUTOMATIC) break block61;
                                    }
                                    catch (Throwable throwable) {
                                        if (responseDispose == ResponseDisposeHandling.AUTOMATIC) {
                                            IOUtils.closeQuietly((Closeable)response);
                                        }
                                        if (refreshTopology.booleanValue() || refreshClientConfiguration.booleanValue()) {
                                            ServerNode serverNode = new ServerNode();
                                            serverNode.setUrl(chosenNode.getUrl());
                                            serverNode.setDatabase(this._databaseName);
                                            CompletableFuture<Boolean> topologyTask = refreshTopology != false ? this.updateTopologyAsync(serverNode, 0) : CompletableFuture.completedFuture(false);
                                            CompletableFuture<Void> clientConfiguration = refreshClientConfiguration != false ? this.updateClientConfigurationAsync() : CompletableFuture.completedFuture(null);
                                            try {
                                                CompletableFuture.allOf(topologyTask, clientConfiguration).get();
                                            }
                                            catch (Exception e) {
                                                throw ExceptionsUtils.unwrapException(e);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    IOUtils.closeQuietly((Closeable)response);
                                }
                                if (refreshTopology.booleanValue() || refreshClientConfiguration.booleanValue()) {
                                    ServerNode serverNode = new ServerNode();
                                    serverNode.setUrl(chosenNode.getUrl());
                                    serverNode.setDatabase(this._databaseName);
                                    CompletableFuture<Boolean> topologyTask = refreshTopology != false ? this.updateTopologyAsync(serverNode, 0) : CompletableFuture.completedFuture(false);
                                    CompletableFuture<Void> clientConfiguration = refreshClientConfiguration != false ? this.updateClientConfigurationAsync() : CompletableFuture.completedFuture(null);
                                    try {
                                        CompletableFuture.allOf(topologyTask, clientConfiguration).get();
                                    }
                                    catch (Exception e) {
                                        throw ExceptionsUtils.unwrapException(e);
                                    }
                                }
                                return;
                            }
                            if (response.getStatusLine().getStatusCode() < 400) break block62;
                            if (!this.handleUnsuccessfulResponse(chosenNode, nodeIndex, command, request, response, (String)urlRef.value, sessionInfo, shouldRetry)) {
                                Header dbMissingHeader = response.getFirstHeader("Database-Missing");
                                if (dbMissingHeader != null && dbMissingHeader.getValue() != null) {
                                    throw new DatabaseDoesNotExistException(dbMissingHeader.getValue());
                                }
                                if (command.getFailedNodes().size() == 0) {
                                    throw new IllegalStateException("Received unsuccessful response and couldn't recover from it. Also, no record of exceptions per failed nodes. This is weird and should not happen.");
                                }
                                if (command.getFailedNodes().size() == 1) {
                                    Collection<Exception> values = command.getFailedNodes().values();
                                    values.stream().findFirst().ifPresent(v -> {
                                        throw new RuntimeException((Throwable)v);
                                    });
                                }
                                throw new AllTopologyNodesDownException("Received unsuccessful response from all servers and couldn't recover from it.");
                            }
                            if (responseDispose != ResponseDisposeHandling.AUTOMATIC) break block63;
                            IOUtils.closeQuietly((Closeable)response);
                        }
                        if (refreshTopology.booleanValue() || refreshClientConfiguration.booleanValue()) {
                            ServerNode serverNode = new ServerNode();
                            serverNode.setUrl(chosenNode.getUrl());
                            serverNode.setDatabase(this._databaseName);
                            CompletableFuture<Boolean> topologyTask = refreshTopology != false ? this.updateTopologyAsync(serverNode, 0) : CompletableFuture.completedFuture(false);
                            CompletableFuture<Void> clientConfiguration = refreshClientConfiguration != false ? this.updateClientConfigurationAsync() : CompletableFuture.completedFuture(null);
                            try {
                                CompletableFuture.allOf(topologyTask, clientConfiguration).get();
                            }
                            catch (Exception e) {
                                throw ExceptionsUtils.unwrapException(e);
                            }
                        }
                        return;
                    }
                    responseDispose = command.processResponse(this.cache, response, (String)urlRef.value);
                    this._lastReturnedResponse = new Date();
                    if (responseDispose != ResponseDisposeHandling.AUTOMATIC) break block64;
                    IOUtils.closeQuietly((Closeable)response);
                }
                if (!refreshTopology.booleanValue() && !refreshClientConfiguration.booleanValue()) break block65;
                ServerNode serverNode = new ServerNode();
                serverNode.setUrl(chosenNode.getUrl());
                serverNode.setDatabase(this._databaseName);
                CompletableFuture<Boolean> topologyTask = refreshTopology != false ? this.updateTopologyAsync(serverNode, 0) : CompletableFuture.completedFuture(false);
                CompletableFuture<Void> clientConfiguration = refreshClientConfiguration != false ? this.updateClientConfigurationAsync() : CompletableFuture.completedFuture(null);
                try {
                    CompletableFuture.allOf(topologyTask, clientConfiguration).get();
                }
                catch (Exception e) {
                    throw ExceptionsUtils.unwrapException(e);
                }
            }
        }
    }

    private <TResult> void throwFailedToContactAllNodes(RavenCommand<TResult> command, HttpRequestBase request, Exception e, Exception timeoutException) {
        String message = "Tried to send " + command.resultClass.getName() + " request via " + request.getMethod() + " " + request.getURI() + " to all configured nodes in the topology, all of them seem to be down or not responding. I've tried to access the following nodes: ";
        message = message + Optional.ofNullable(this._nodeSelector).map(x -> x.getTopology().getNodes().stream().map(ServerNode::getUrl).collect(Collectors.joining(", "))).orElse("");
        if (this.topologyTakenFromNode != null) {
            String nodes = Optional.ofNullable(this._nodeSelector).map(x -> x.getTopology().getNodes().stream().map(n -> "( url: " + n.getUrl() + ", clusterTag: " + n.getClusterTag() + ", serverRole: " + (Object)((Object)n.getServerRole()) + ")").collect(Collectors.joining(", "))).orElse("");
            message = message + System.lineSeparator() + "I was able to fetch " + this.topologyTakenFromNode.getDatabase() + " topology from " + this.topologyTakenFromNode.getUrl() + "." + System.lineSeparator() + "Fetched topology: " + nodes;
        }
        throw new AllTopologyNodesDownException(message, timeoutException != null ? timeoutException : e);
    }

    public boolean inSpeedTestPhase() {
        return Optional.ofNullable(this._nodeSelector).map(x -> x.inSpeedTestPhase()).orElse(false);
    }

    private <TResult> boolean shouldExecuteOnAll(ServerNode chosenNode, RavenCommand<TResult> command) {
        return this._readBalanceBehavior == ReadBalanceBehavior.FASTEST_NODE && this._nodeSelector != null && this._nodeSelector.inSpeedTestPhase() && Optional.ofNullable(this._nodeSelector).map(NodeSelector::getTopology).map(x -> x.getNodes()).map(x -> x.size() > 1).orElse(false) != false && command.isReadRequest() && command.getResponseType() == RavenCommandResponseType.OBJECT && chosenNode != null;
    }

    private <TResult> CloseableHttpResponse executeOnAllToFigureOutTheFastest(ServerNode chosenNode, RavenCommand<TResult> command) {
        AtomicInteger numberOfFailedTasks = new AtomicInteger();
        CompletableFuture<IndexAndResponse> preferredTask = null;
        List<ServerNode> nodes = this._nodeSelector.getTopology().getNodes();
        ArrayList<Object> tasks = new ArrayList<Object>(Collections.nCopies(nodes.size(), null));
        for (int i = 0; i < nodes.size(); ++i) {
            int taskNumber = i;
            this.numberOfServerRequests.incrementAndGet();
            CompletableFuture<IndexAndResponse> task = CompletableFuture.supplyAsync(() -> {
                try {
                    Reference<String> strRef = new Reference<String>();
                    HttpRequestBase request = this.createRequest((ServerNode)nodes.get(taskNumber), command, strRef);
                    return new IndexAndResponse(taskNumber, command.send(this.httpClient, request));
                }
                catch (Exception e) {
                    numberOfFailedTasks.incrementAndGet();
                    tasks.set(taskNumber, null);
                    throw new RuntimeException("Request execution failed", e);
                }
            });
            if (nodes.get(i).getClusterTag().equals(chosenNode.getClusterTag())) {
                preferredTask = task;
            } else {
                task.thenAcceptAsync(result -> IOUtils.closeQuietly((Closeable)result.response));
            }
            tasks.set(i, task);
        }
        while (numberOfFailedTasks.get() < tasks.size()) {
            try {
                IndexAndResponse fastest = (IndexAndResponse)CompletableFuture.anyOf((CompletableFuture[])tasks.stream().filter(x -> x != null).toArray(CompletableFuture[]::new)).get();
                this._nodeSelector.recordFastest(fastest.index, nodes.get(fastest.index));
                break;
            }
            catch (InterruptedException | ExecutionException e) {
                for (int i = 0; i < nodes.size(); ++i) {
                    if (!((CompletableFuture)tasks.get(i)).isCompletedExceptionally()) continue;
                    numberOfFailedTasks.incrementAndGet();
                    tasks.set(i, null);
                }
            }
        }
        try {
            return ((IndexAndResponse)preferredTask.get()).response;
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionsUtils.unwrapException(e);
        }
    }

    private <TResult> HttpCache.ReleaseCacheItem getFromCache(RavenCommand<TResult> command, String url, Reference<String> cachedChangeVector, Reference<String> cachedValue) {
        if (command.canCache() && command.isReadRequest() && command.getResponseType() == RavenCommandResponseType.OBJECT) {
            return this.cache.get(url, cachedChangeVector, cachedValue);
        }
        cachedChangeVector.value = null;
        cachedValue.value = null;
        return new HttpCache.ReleaseCacheItem(null);
    }

    private <TResult> HttpRequestBase createRequest(ServerNode node, RavenCommand<TResult> command, Reference<String> url) {
        try {
            HttpRequestBase request = command.createRequest(node, url);
            request.setURI(new URI((String)url.value));
            if (!request.containsHeader("Raven-Client-Version")) {
                request.addHeader("Raven-Client-Version", CLIENT_VERSION);
            }
            if (requestPostProcessor != null) {
                requestPostProcessor.accept(request);
            }
            return request;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to parse URL", e);
        }
    }

    private <TResult> boolean handleUnsuccessfulResponse(ServerNode chosenNode, Integer nodeIndex, RavenCommand<TResult> command, HttpRequestBase request, CloseableHttpResponse response, String url, SessionInfo sessionInfo, boolean shouldRetry) {
        try {
            switch (response.getStatusLine().getStatusCode()) {
                case 404: {
                    this.cache.setNotFound(url);
                    switch (command.getResponseType()) {
                        case EMPTY: {
                            return true;
                        }
                        case OBJECT: {
                            command.setResponse(null, false);
                            break;
                        }
                        default: {
                            command.setResponseRaw(response, null);
                        }
                    }
                    return true;
                }
                case 403: {
                    throw new AuthorizationException("Forbidden access to " + chosenNode.getDatabase() + "@" + chosenNode.getUrl() + ", " + request.getMethod() + " " + request.getURI());
                }
                case 410: {
                    if (!shouldRetry) {
                        return false;
                    }
                    this.updateTopologyAsync(chosenNode, Integer.MAX_VALUE, true).get();
                    CurrentIndexAndNode currentIndexAndNode = this.chooseNodeForRequest(command, sessionInfo);
                    this.execute(currentIndexAndNode.currentNode, currentIndexAndNode.currentIndex, command, false, sessionInfo);
                    return true;
                }
                case 408: 
                case 502: 
                case 503: 
                case 504: {
                    this.handleServerDown(url, chosenNode, nodeIndex, command, request, response, null, sessionInfo);
                    break;
                }
                case 409: {
                    RequestExecutor.handleConflict(response);
                    break;
                }
                default: {
                    command.onResponseFailure(response);
                    ExceptionDispatcher.throwException(response);
                    break;
                }
            }
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw ExceptionsUtils.unwrapException(e);
        }
        return false;
    }

    private static void handleConflict(CloseableHttpResponse response) {
        ExceptionDispatcher.throwException(response);
    }

    public static InputStream readAsStream(CloseableHttpResponse response) throws IOException {
        return response.getEntity().getContent();
    }

    private <TResult> boolean handleServerDown(String url, ServerNode chosenNode, Integer nodeIndex, RavenCommand<TResult> command, HttpRequestBase request, CloseableHttpResponse response, Exception e, SessionInfo sessionInfo) {
        if (command.getFailedNodes() == null) {
            command.setFailedNodes(new HashMap<ServerNode, Exception>());
        }
        RequestExecutor.addFailedResponseToCommand(chosenNode, command, request, response, e);
        if (nodeIndex == null) {
            return false;
        }
        this.spawnHealthChecks(chosenNode, nodeIndex);
        if (this._nodeSelector == null) {
            return false;
        }
        this._nodeSelector.onFailedRequest(nodeIndex);
        CurrentIndexAndNode currentIndexAndNode = this._nodeSelector.getPreferredNode();
        if (command.getFailedNodes().containsKey(currentIndexAndNode.currentNode)) {
            return false;
        }
        this.execute(currentIndexAndNode.currentNode, currentIndexAndNode.currentIndex, command, false, sessionInfo);
        return true;
    }

    private void spawnHealthChecks(ServerNode chosenNode, int nodeIndex) {
        NodeStatus nodeStatus = new NodeStatus(this, nodeIndex, chosenNode);
        if (this._failedNodesTimers.putIfAbsent(chosenNode, nodeStatus) == null) {
            nodeStatus.startTimer();
        }
    }

    private void checkNodeStatusCallback(NodeStatus nodeStatus) {
        block10: {
            List<ServerNode> copy = this.getTopologyNodes();
            if (nodeStatus.nodeIndex >= copy.size()) {
                return;
            }
            ServerNode serverNode = copy.get(nodeStatus.nodeIndex);
            if (serverNode != nodeStatus.node) {
                return;
            }
            try {
                try {
                    this.performHealthCheck(serverNode, nodeStatus.nodeIndex);
                }
                catch (Exception e) {
                    NodeStatus status;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)(serverNode.getClusterTag() + " is still down"), (Throwable)e);
                    }
                    if ((status = (NodeStatus)this._failedNodesTimers.get(nodeStatus.node)) != null) {
                        nodeStatus.updateTimer();
                    }
                    return;
                }
                NodeStatus status = (NodeStatus)this._failedNodesTimers.get(nodeStatus.node);
                if (status != null) {
                    this._failedNodesTimers.remove(status);
                    status.close();
                }
                if (this._nodeSelector != null) {
                    this._nodeSelector.restoreNodeIndex(nodeStatus.nodeIndex);
                }
            }
            catch (Exception e) {
                if (!logger.isInfoEnabled()) break block10;
                logger.info((Object)"Failed to check node topology, will ignore this node until next topology update", (Throwable)e);
            }
        }
    }

    protected void performHealthCheck(ServerNode serverNode, int nodeIndex) {
        this.execute(serverNode, nodeIndex, new GetStatisticsCommand("failure=check"), false, null);
    }

    private static <TResult> void addFailedResponseToCommand(ServerNode chosenNode, RavenCommand<TResult> command, HttpRequestBase request, CloseableHttpResponse response, Exception e) {
        if (response != null && response.getEntity() != null) {
            String responseJson = null;
            try {
                responseJson = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
                RavenException readException = ExceptionDispatcher.get((ExceptionDispatcher.ExceptionSchema)JsonExtensions.getDefaultMapper().readValue(responseJson, ExceptionDispatcher.ExceptionSchema.class), response.getStatusLine().getStatusCode());
                command.getFailedNodes().put(chosenNode, readException);
            }
            catch (Exception __) {
                ExceptionDispatcher.ExceptionSchema exceptionSchema = new ExceptionDispatcher.ExceptionSchema();
                exceptionSchema.setUrl(request.getURI().toString());
                exceptionSchema.setMessage("Get unrecognized response from the server");
                exceptionSchema.setError(responseJson);
                exceptionSchema.setType("Unparsable Server Response");
                RavenException exceptionToUse = ExceptionDispatcher.get(exceptionSchema, response.getStatusLine().getStatusCode());
                command.getFailedNodes().put(chosenNode, exceptionToUse);
            }
            return;
        }
        ExceptionDispatcher.ExceptionSchema exceptionSchema = new ExceptionDispatcher.ExceptionSchema();
        exceptionSchema.setUrl(request.getURI().toString());
        exceptionSchema.setMessage(e.getMessage());
        exceptionSchema.setError(e.toString());
        exceptionSchema.setType(e.getClass().getCanonicalName());
        command.getFailedNodes().put(chosenNode, ExceptionDispatcher.get(exceptionSchema, 500));
    }

    @Override
    public void close() {
        if (this._disposed) {
            return;
        }
        try {
            this._updateTopologySemaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this._disposed) {
            return;
        }
        this._disposed = true;
        this.cache.close();
        if (this._updateTopologyTimer != null) {
            this._updateTopologyTimer.close();
        }
        this.disposeAllFailedNodesTimers();
    }

    private CloseableHttpClient createClient() {
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setMaxConnPerRoute(10).disableContentCompression().setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(0, false)).setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build());
        if (this.certificate != null) {
            try {
                httpClientBuilder.setSSLHostnameVerifier((s, sslSession) -> true);
                SSLContext context = SSLContexts.custom().loadKeyMaterial(this.certificate, "".toCharArray()).build();
                httpClientBuilder.setSSLContext(context);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IllegalStateException("Unable to configure ssl context: " + e.getMessage(), e);
            }
        }
        if (configureHttpClient != null) {
            configureHttpClient.accept(httpClientBuilder);
        }
        return httpClientBuilder.build();
    }

    public CurrentIndexAndNode getPreferredNode() {
        this.ensureNodeSelector();
        return this._nodeSelector.getPreferredNode();
    }

    public CurrentIndexAndNode getNodeBySessionId(int sessionId) {
        this.ensureNodeSelector();
        return this._nodeSelector.getNodeBySessionId(sessionId);
    }

    public CurrentIndexAndNode getFastestNode() {
        this.ensureNodeSelector();
        return this._nodeSelector.getFastestNode();
    }

    private void ensureNodeSelector() {
        if (this._firstTopologyUpdate != null && !this._firstTopologyUpdate.isDone()) {
            ExceptionsUtils.accept(() -> this._firstTopologyUpdate.get());
        }
        if (this._nodeSelector == null) {
            Topology topology = new Topology();
            topology.setNodes(this.getTopologyNodes());
            topology.setEtag(this.topologyEtag);
            this._nodeSelector = new NodeSelector(topology);
        }
    }

    public static class IndexAndResponse {
        public final int index;
        public final CloseableHttpResponse response;

        public IndexAndResponse(int index, CloseableHttpResponse response) {
            this.index = index;
            this.response = response;
        }
    }

    public static class NodeStatus
    implements CleanCloseable {
        private Duration _timerPeriod;
        private final RequestExecutor _requestExecutor;
        public final int nodeIndex;
        public final ServerNode node;
        private Timer _timer;

        public NodeStatus(RequestExecutor requestExecutor, int nodeIndex, ServerNode node) {
            this._requestExecutor = requestExecutor;
            this.nodeIndex = nodeIndex;
            this.node = node;
            this._timerPeriod = Duration.ofMillis(100L);
        }

        private Duration nextTimerPeriod() {
            if (this._timerPeriod.compareTo(Duration.ofSeconds(5L)) >= 0) {
                return Duration.ofSeconds(5L);
            }
            this._timerPeriod = this._timerPeriod.plus(Duration.ofMillis(100L));
            return this._timerPeriod;
        }

        public void startTimer() {
            this._timer = new Timer(this::timerCallback, this._timerPeriod);
        }

        public void updateTimer() {
            this._timer.change(this.nextTimerPeriod());
        }

        private void timerCallback() {
            if (!this._requestExecutor._disposed) {
                this._requestExecutor.checkNodeStatusCallback(this);
            }
        }

        @Override
        public void close() {
            this._timer.close();
        }
    }
}

