/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.serverwide.commands;

import java.io.IOException;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.http.Topology;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.util.UrlUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetTopologyCommand
extends RavenCommand<Topology> {
    public GetTopologyCommand() {
        super(Topology.class);
    }

    @Override
    public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
        url.value = node.getUrl() + "/topology?name=" + node.getDatabase();
        if (node.getUrl().toLowerCase().contains(".fiddler")) {
            url.value = url.value + "&localUrl=" + UrlUtils.escapeDataString(node.getUrl());
        }
        return new HttpGet();
    }

    @Override
    public void setResponse(String response, boolean fromCache) throws IOException {
        if (response == null) {
            return;
        }
        this.result = this.mapper.readValue(response, this.resultClass);
    }

    @Override
    public boolean isReadRequest() {
        return true;
    }
}

