/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.serverwide.operations;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.serverwide.operations.IServerOperation;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;

public class GetDatabaseNamesOperation
implements IServerOperation<String[]> {
    private final int _start;
    private final int _pageSize;

    public GetDatabaseNamesOperation(int _start, int _pageSize) {
        this._start = _start;
        this._pageSize = _pageSize;
    }

    @Override
    public RavenCommand<String[]> getCommand(DocumentConventions conventions) {
        return new GetDatabaseNamesCommand(this._start, this._pageSize);
    }

    private static class GetDatabaseNamesCommand
    extends RavenCommand<String[]> {
        private final int _start;
        private final int _pageSize;

        public GetDatabaseNamesCommand(int _start, int _pageSize) {
            super(String[].class);
            this._start = _start;
            this._pageSize = _pageSize;
        }

        @Override
        public boolean isReadRequest() {
            return true;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases?start=" + this._start + "&pageSize=" + this._pageSize + "&namesOnly=true";
            return new HttpGet();
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            JsonNode databases;
            if (response == null) {
                GetDatabaseNamesCommand.throwInvalidResponse();
                return;
            }
            JsonNode names = this.mapper.readTree(response);
            if (!names.has("Databases")) {
                GetDatabaseNamesCommand.throwInvalidResponse();
            }
            if (!(databases = names.get("Databases")).isArray()) {
                GetDatabaseNamesCommand.throwInvalidResponse();
            }
            ArrayNode dbNames = (ArrayNode)databases;
            String[] databaseNames = new String[dbNames.size()];
            for (int i = 0; i < dbNames.size(); ++i) {
                databaseNames[i] = dbNames.get(i).asText();
            }
            this.result = databaseNames;
        }
    }
}

