/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.serverwide.operations;

import net.ravendb.client.documents.DocumentStoreBase;
import net.ravendb.client.documents.operations.Operation;
import net.ravendb.client.documents.operations.OperationIdResult;
import net.ravendb.client.documents.operations.ServerWideOperation;
import net.ravendb.client.http.ClusterRequestExecutor;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.VoidRavenCommand;
import net.ravendb.client.serverwide.operations.IServerOperation;
import net.ravendb.client.serverwide.operations.IVoidServerOperation;

public class ServerOperationExecutor {
    private final DocumentStoreBase store;
    private final ClusterRequestExecutor requestExecutor;

    public ServerOperationExecutor(DocumentStoreBase store) {
        this.store = store;
        this.requestExecutor = store.getConventions().isDisableTopologyUpdates() ? ClusterRequestExecutor.createForSingleNode(store.getUrls()[0], store.getCertificate()) : ClusterRequestExecutor.create(store.getUrls(), store.getCertificate());
    }

    public void send(IVoidServerOperation operation) {
        VoidRavenCommand command = operation.getCommand(this.requestExecutor.getConventions());
        this.requestExecutor.execute(command);
    }

    public <TResult> TResult send(IServerOperation<TResult> operation) {
        RavenCommand<TResult> command = operation.getCommand(this.requestExecutor.getConventions());
        this.requestExecutor.execute(command);
        return command.getResult();
    }

    public Operation sendAsync(IServerOperation<OperationIdResult> operation) {
        RavenCommand<OperationIdResult> command = operation.getCommand(this.requestExecutor.getConventions());
        this.requestExecutor.execute(command);
        return new ServerWideOperation(this.requestExecutor, this.requestExecutor.getConventions(), command.getResult().getOperationId());
    }
}

