/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.serverwide.operations;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.IMaintenanceOperation;
import net.ravendb.client.documents.session.EntityToJson;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.serverwide.ExternalReplication;
import net.ravendb.client.serverwide.operations.ModifyOngoingTaskResult;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class UpdateExternalReplicationOperation
implements IMaintenanceOperation<ModifyOngoingTaskResult> {
    private final ExternalReplication _newWatcher;

    public UpdateExternalReplicationOperation(ExternalReplication newWatcher) {
        this._newWatcher = newWatcher;
    }

    @Override
    public RavenCommand<ModifyOngoingTaskResult> getCommand(DocumentConventions conventions) {
        return new UpdateExternalReplication(this._newWatcher);
    }

    private static class UpdateExternalReplication
    extends RavenCommand<ModifyOngoingTaskResult> {
        private final ExternalReplication _newWatcher;

        public UpdateExternalReplication(ExternalReplication newWatcher) {
            super(ModifyOngoingTaskResult.class);
            this._newWatcher = newWatcher;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/admin/tasks/external-replication";
            HttpPost request = new HttpPost();
            request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
                try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                    generator.writeStartObject();
                    generator.writeFieldName("Watcher");
                    ObjectNode tree = EntityToJson.convertEntityToJson(this._newWatcher, DocumentConventions.defaultConventions);
                    generator.writeTree((TreeNode)tree);
                    generator.writeEndObject();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, ContentType.APPLICATION_JSON));
            return request;
        }

        @Override
        public boolean isReadRequest() {
            return false;
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                UpdateExternalReplication.throwInvalidResponse();
            }
            this.result = this.mapper.readValue(response, this.resultClass);
        }
    }
}

