/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.serverwide.operations.connectionStrings;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import net.ravendb.client.documents.conventions.DocumentConventions;
import net.ravendb.client.documents.operations.IMaintenanceOperation;
import net.ravendb.client.documents.session.EntityToJson;
import net.ravendb.client.http.RavenCommand;
import net.ravendb.client.http.ServerNode;
import net.ravendb.client.json.ContentProviderHttpEntity;
import net.ravendb.client.primitives.Reference;
import net.ravendb.client.serverwide.ConnectionString;
import net.ravendb.client.serverwide.operations.connectionStrings.PutConnectionStringResult;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;

public class PutConnectionStringOperation<T extends ConnectionString>
implements IMaintenanceOperation<PutConnectionStringResult> {
    private final T _connectionString;

    public PutConnectionStringOperation(T connectionString) {
        this._connectionString = connectionString;
    }

    @Override
    public RavenCommand<PutConnectionStringResult> getCommand(DocumentConventions conventions) {
        return new PutConnectionStringCommand<T>(this._connectionString);
    }

    public static class PutConnectionStringCommand<T>
    extends RavenCommand<PutConnectionStringResult> {
        private final T _connectionString;

        public PutConnectionStringCommand(T connectionString) {
            super(PutConnectionStringResult.class);
            this._connectionString = connectionString;
        }

        @Override
        public boolean isReadRequest() {
            return false;
        }

        @Override
        public HttpRequestBase createRequest(ServerNode node, Reference<String> url) {
            url.value = node.getUrl() + "/databases/" + node.getDatabase() + "/admin/connection-strings";
            HttpPut request = new HttpPut();
            request.setEntity((HttpEntity)new ContentProviderHttpEntity(outputStream -> {
                try (JsonGenerator generator = this.mapper.getFactory().createGenerator(outputStream);){
                    ObjectNode config = EntityToJson.convertEntityToJson(this._connectionString, DocumentConventions.defaultConventions);
                    generator.writeTree((TreeNode)config);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }, ContentType.APPLICATION_JSON));
            return request;
        }

        @Override
        public void setResponse(String response, boolean fromCache) throws IOException {
            if (response == null) {
                PutConnectionStringCommand.throwInvalidResponse();
            }
            this.result = this.mapper.readValue(response, this.resultClass);
        }
    }
}

