/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.test.driver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import net.ravendb.client.test.driver.RavenServerLocator;
import org.apache.commons.lang3.ArrayUtils;

public abstract class RavenServerRunner {
    public static Process run(RavenServerLocator locator) throws IOException {
        ProcessStartInfo processStartInfo = RavenServerRunner.getProcessStartInfo(locator);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(processStartInfo.getCommand());
        arguments.addAll(Arrays.asList(processStartInfo.getArguments()));
        ProcessBuilder processBuilder = new ProcessBuilder(arguments);
        return processBuilder.start();
    }

    private static ProcessStartInfo getProcessStartInfo(RavenServerLocator locator) throws IOException {
        File serverPath = new File(locator.getServerPath());
        if (!serverPath.exists()) {
            throw new FileNotFoundException("Server file was not found: " + locator.getServerPath());
        }
        Object[] commandArguments = new String[]{locator.withHttps() ? "--ServerUrl=https://127.0.0.1:8085" : "--ServerUrl=http://127.0.0.1:0", "--RunInMemory=true", "--Testing.ParentProcessId=" + RavenServerRunner.getProcessId("0")};
        commandArguments = (String[])ArrayUtils.addAll((Object[])locator.getCommandArguments(), (Object[])commandArguments);
        ProcessStartInfo processStartInfo = new ProcessStartInfo();
        processStartInfo.setCommand(locator.getCommand());
        processStartInfo.setArguments((String[])commandArguments);
        return processStartInfo;
    }

    private static String getProcessId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    private static class ProcessStartInfo {
        private String command;
        private String[] arguments;

        private ProcessStartInfo() {
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public void setArguments(String[] arguments) {
            this.arguments = arguments;
        }
    }
}

