/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Inflector {
    private static final List<Rule> plurals = new ArrayList<Rule>();
    private static final List<Rule> singulars = new ArrayList<Rule>();
    private static final List<String> uncountables = new ArrayList<String>();

    private Inflector() {
    }

    public static String pluralize(String word) {
        return Inflector.applyRules(plurals, word);
    }

    public static String singularize(String word) {
        return Inflector.applyRules(singulars, word);
    }

    public static String capitalize(String word) {
        return StringUtils.capitalize((String)word);
    }

    private static void addIrregular(String singular, String plural) {
        Inflector.addPlural("(" + singular.charAt(0) + ")" + singular.substring(1) + "$", "$1" + plural.substring(1));
        Inflector.addSingular("(" + plural.charAt(0) + ")" + plural.substring(1) + "$", "$1" + singular.substring(1));
    }

    private static void addUncountable(String word) {
        uncountables.add(word.toLowerCase());
    }

    private static void addPlural(String rule, String replacement) {
        plurals.add(new Rule(rule, replacement));
    }

    private static void addSingular(String rule, String replacement) {
        singulars.add(new Rule(rule, replacement));
    }

    private static String applyRules(List<Rule> rules, String word) {
        String result = word;
        if (!uncountables.contains(word.toLowerCase())) {
            Rule rule;
            for (int i = rules.size() - 1; i >= 0 && (result = (rule = rules.get(i)).apply(word)) == null; --i) {
            }
        }
        return result;
    }

    static {
        Inflector.addPlural("(.*)$", "$1s");
        Inflector.addPlural("(.*)s$", "$1s");
        Inflector.addPlural("(ax|test)is$", "$1es");
        Inflector.addPlural("(octop|vir)us$", "$1i");
        Inflector.addPlural("(alias|status)$", "$1es");
        Inflector.addPlural("(bu)s$", "$1ses");
        Inflector.addPlural("(buffal|tomat)o$", "$1oes");
        Inflector.addPlural("([ti])um$", "$1a");
        Inflector.addPlural("(.*)sis$", "$1ses");
        Inflector.addPlural("(?:([^f])fe|([lr])f)$", "$1$2ves");
        Inflector.addPlural("(hive)$", "$1s");
        Inflector.addPlural("([^aeiouy]|qu)y$", "$1ies");
        Inflector.addPlural("(x|ch|ss|sh)$", "$1es");
        Inflector.addPlural("(matr|vert|ind)ix|ex$", "$1ices");
        Inflector.addPlural("([m|l])ouse$", "$1ice");
        Inflector.addPlural("^(ox)$", "$1en");
        Inflector.addPlural("(quiz)$", "$1zes");
        Inflector.addSingular("(.*)s$", "");
        Inflector.addSingular("(n)ews$", "$1ews");
        Inflector.addSingular("([ti])a$", "$1um");
        Inflector.addSingular("((a)naly|(b)a|(d)iagno|(p)arenthe|(p)rogno|(s)ynop|(t)he)ses$", "$1$2sis");
        Inflector.addSingular("(^analy)ses$", "$1sis");
        Inflector.addSingular("([^f])ves$", "$1fe");
        Inflector.addSingular("(hive)s$", "$1");
        Inflector.addSingular("(tive)s$", "$1");
        Inflector.addSingular("([lr])ves$", "$1f");
        Inflector.addSingular("([^aeiouy]|qu)ies$", "$1y");
        Inflector.addSingular("(s)eries$", "$1eries");
        Inflector.addSingular("(m)ovies$", "$1ovie");
        Inflector.addSingular("(x|ch|ss|sh)es$", "$1");
        Inflector.addSingular("([m|l])ice$", "$1ouse");
        Inflector.addSingular("(bus)es$", "$1");
        Inflector.addSingular("(o)es$", "$1");
        Inflector.addSingular("(shoe)s$", "$1");
        Inflector.addSingular("(cris|ax|test)es$", "$1is");
        Inflector.addSingular("(octop|vir)i$", "$1us");
        Inflector.addSingular("(alias|status)es$", "$1");
        Inflector.addSingular("^(ox)en", "$1");
        Inflector.addSingular("(vert|ind)ices$", "$1ex");
        Inflector.addSingular("(matr)ices$", "$1ix");
        Inflector.addSingular("(quiz)zes$", "$1");
        Inflector.addIrregular("person", "people");
        Inflector.addIrregular("man", "men");
        Inflector.addIrregular("child", "children");
        Inflector.addIrregular("sex", "sexes");
        Inflector.addIrregular("move", "moves");
        Inflector.addUncountable("equipment");
        Inflector.addUncountable("information");
        Inflector.addUncountable("rice");
        Inflector.addUncountable("money");
        Inflector.addUncountable("species");
        Inflector.addUncountable("series");
        Inflector.addUncountable("fish");
        Inflector.addUncountable("sheep");
    }

    private static class Rule {
        private final Pattern regex;
        private final String replacement;

        public Rule(String pattern, String replacement) {
            this.regex = Pattern.compile(pattern, 2);
            this.replacement = replacement;
        }

        public String apply(String word) {
            Matcher matcher = this.regex.matcher(word);
            boolean find = matcher.find();
            if (!find) {
                return null;
            }
            return matcher.replaceFirst(this.replacement);
        }
    }
}

