/*
 * Decompiled with CFR 0.152.
 */
package net.ravendb.client.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import net.ravendb.client.primitives.Reference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlUtils {
    public static final Character DUMMY_CHAR = Character.valueOf('\uffff');
    private static final Log log = LogFactory.getLog((String)UrlUtils.class.getCanonicalName());
    private static final char[] HEX_UPPER_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final short c_MaxAsciiCharsReallocate = 40;
    private static final short c_MaxUnicodeCharsReallocate = 40;
    private static final short c_MaxUTF_8BytesPerUnicodeChar = 4;
    private static final short c_EncodedCharsPerByte = 3;

    public static String escapeDataString(String stringToEscape) {
        if (stringToEscape == null) {
            throw new IllegalArgumentException("String is null");
        }
        if (stringToEscape.length() == 0) {
            return "";
        }
        Reference<Integer> position = new Reference<Integer>(0);
        char[] dest = UrlUtils.escapeString(stringToEscape, 0, stringToEscape.length(), null, position, false);
        if (dest == null) {
            return stringToEscape;
        }
        return new String(dest, 0, (int)((Integer)position.value));
    }

    private static void escapeAsciiChar(char ch, char[] to, Reference<Integer> posRef) {
        Reference<Integer> reference = posRef;
        Integer n = (Integer)reference.value;
        reference.value = (Integer)reference.value + 1;
        Integer n2 = reference.value;
        to[n.intValue()] = 37;
        reference = posRef;
        n = (Integer)reference.value;
        reference.value = (Integer)reference.value + 1;
        n2 = reference.value;
        to[n.intValue()] = HEX_UPPER_CHARS[(ch & 0xF0) >> 4];
        reference = posRef;
        n = (Integer)reference.value;
        reference.value = (Integer)reference.value + 1;
        n2 = reference.value;
        to[n.intValue()] = HEX_UPPER_CHARS[ch & 0xF];
    }

    private static char[] escapeString(String input, int start, int end, char[] dest, Reference<Integer> destPos, boolean isUriString) {
        int i;
        int prevInputPos = start;
        byte[] bytes = new byte[160];
        String pStr = input;
        for (i = start; i < end; ++i) {
            char ch = pStr.charAt(i);
            if (ch > '\u007f') {
                short count;
                short maxSize = (short)Math.min(end - i, 39);
                for (count = 1; count < maxSize && pStr.charAt(i + count) > '\u007f'; count = (short)(count + 1)) {
                }
                if (pStr.charAt(i + count - 1) >= '\ud800' && pStr.charAt(i + count - 1) <= '\udbff') {
                    if (count == 1 || count == end - i) {
                        throw new RuntimeException(input + ": BAD_STRING");
                    }
                    count = (short)(count + 1);
                }
                dest = UrlUtils.ensureDestinationSize(pStr, dest, i, (short)(count * 4 * 3), 480, destPos, prevInputPos);
                String substring = pStr.substring(i, i + count);
                byte[] subStringBytes = substring.getBytes();
                System.arraycopy(subStringBytes, 0, bytes, 0, subStringBytes.length);
                short numberOfBytes = (short)subStringBytes.length;
                if (numberOfBytes == 0) {
                    throw new RuntimeException(input + ": BAD_STRING");
                }
                i += count - 1;
                for (count = 0; count < numberOfBytes; count = (short)(count + 1)) {
                    UrlUtils.escapeAsciiChar((char)bytes[count], dest, destPos);
                }
                prevInputPos = i + 1;
                continue;
            }
            if (!(isUriString ? UrlUtils.isNotReservedNotUnreservedNotHash(ch) : UrlUtils.isNotUnreserved(ch))) continue;
            dest = UrlUtils.ensureDestinationSize(pStr, dest, i, (short)3, 120, destPos, prevInputPos);
            UrlUtils.escapeAsciiChar(ch, dest, destPos);
            prevInputPos = i + 1;
        }
        if (prevInputPos != i && (prevInputPos != start || dest != null)) {
            dest = UrlUtils.ensureDestinationSize(pStr, dest, i, (short)0, 0, destPos, prevInputPos);
        }
        return dest;
    }

    private static char[] ensureDestinationSize(String pStr, char[] dest, int currentInputPos, short charsToAdd, int minReallocateChars, Reference<Integer> destPos, int prevInputPos) {
        if (dest == null || dest.length < (Integer)destPos.value + (currentInputPos - prevInputPos) + charsToAdd) {
            char[] newResult = new char[(Integer)destPos.value + (currentInputPos - prevInputPos) + minReallocateChars];
            if (dest != null && (Integer)destPos.value != 0) {
                System.arraycopy(dest, 0, newResult, 0, Math.min(dest.length, newResult.length));
            }
            dest = newResult;
        }
        while (prevInputPos != currentInputPos) {
            Reference<Integer> reference = destPos;
            Integer n = (Integer)reference.value;
            reference.value = (Integer)reference.value + 1;
            Integer n2 = reference.value;
            dest[n.intValue()] = pStr.charAt(prevInputPos++);
        }
        return dest;
    }

    private static boolean isNotReservedNotUnreservedNotHash(char c) {
        if (c > 'z' && c != '~') {
            return true;
        }
        if (c > 'Z' && c < 'a' && c != '_') {
            return true;
        }
        if (c < '!') {
            return true;
        }
        return c == '>' || c == '<' || c == '%' || c == '\"' || c == '`';
    }

    private static boolean isNotUnreserved(char c) {
        if (c > 'z' && c != '~') {
            return true;
        }
        if (c > '9' && c < 'A' || c > 'Z' && c < 'a' && c != '_') {
            return true;
        }
        if (c < '\'' && c != '!') {
            return true;
        }
        return c == '+' || c == ',' || c == '/';
    }

    public static String escapeUriString(String stringToEscape) {
        if (stringToEscape == null) {
            throw new IllegalArgumentException("String is null");
        }
        if (stringToEscape.length() == 0) {
            return "";
        }
        Reference<Integer> position = new Reference<Integer>(0);
        char[] dest = UrlUtils.escapeString(stringToEscape, 0, stringToEscape.length(), null, position, true);
        if (dest == null) {
            return stringToEscape;
        }
        return new String(dest, 0, (int)((Integer)position.value));
    }

    public static String unescapeDataString(String input) {
        try {
            if (input == null) {
                return null;
            }
            return URLDecoder.decode(input, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

