/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.CucumberException;
import cucumber.runtime.java.ObjectFactory;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.serenitybdd.core.Serenity;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;

public class SerenityObjectFactory
implements ObjectFactory {
    private final Set<Class<?>> classes = Collections.synchronizedSet(new HashSet());
    private final Map<Class<?>, Object> instances = Collections.synchronizedMap(new HashMap());

    public void start() {
    }

    public void stop() {
        this.instances.clear();
        Serenity.done((boolean)false);
    }

    public void addClass(Class<?> clazz) {
        this.classes.add(clazz);
    }

    public <T> T getInstance(Class<T> type) {
        T instance = type.cast(this.instances.get(type));
        if (instance == null) {
            instance = this.cacheNewInstance(type);
        }
        return instance;
    }

    private <T> T cacheNewInstance(Class<T> type) {
        T instance = this.newInstance(type);
        this.instances.put(type, instance);
        return instance;
    }

    private <T> T newInstance(Class<T> type) {
        T instance;
        try {
            Constructor<T> constructor = type.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            instance = this.createNewPageEnabledStepCandidate(type);
        }
        catch (Exception e) {
            throw new CucumberException(String.format("Failed to instantiate %s", type), (Throwable)e);
        }
        Serenity.initializeWithNoStepListener(instance).throwExceptionsImmediately();
        return instance;
    }

    private <T> T createNewPageEnabledStepCandidate(Class<T> type) {
        T newInstance;
        try {
            Pages pageFactory = ThucydidesWebDriverSupport.getPages();
            Class[] constructorArgs = new Class[]{Pages.class};
            Constructor<T> constructor = type.getConstructor(constructorArgs);
            newInstance = constructor.newInstance(pageFactory);
        }
        catch (Exception e) {
            throw new CucumberException(String.format("%s doesn't have an empty or a page enabled constructor.", type), (Throwable)e);
        }
        return newInstance;
    }
}

