/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber;

import ch.lambdaj.Lambda;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cucumber.runtime.StepDefinitionMatch;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.DataTableRow;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.ExamplesTableRow;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import gherkin.formatter.model.Tag;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SerenityListeners;
import net.serenitybdd.core.SerenityReports;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.model.stacktrace.RootCauseAnalyzer;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import org.apache.commons.lang3.StringUtils;
import org.junit.internal.AssumptionViolatedException;

public class SerenityReporter
implements Formatter,
Reporter {
    private static final String OPEN_PARAM_CHAR = "\uff5f";
    private static final String CLOSE_PARAM_CHAR = "\uff60";
    private static final List<String> SKIPPED_TAGS = ImmutableList.of((Object)"@skip", (Object)"@wip");
    public static final String PENDING_STATUS = "pending";
    private final Queue<Step> stepQueue;
    private Configuration systemConfiguration;
    private ThreadLocal<SerenityListeners> thucydidesListenersThreadLocal;
    private final List<BaseStepListener> baseStepListeners;
    private Feature currentFeature;
    private int currentExample = 0;
    private boolean examplesRunning;
    private List<Map<String, String>> exampleRows;
    private int exampleCount = 0;
    private DataTable table;
    private boolean waitingToProcessBackgroundSteps = false;
    private String currentUri;
    private String defaultFeatureName;
    private String defaultFeatureId;
    private boolean uniqueBrowserTag = false;
    private static final String FEATURES_ROOT_PATH = "features";
    private static Optional<TestResult> forcedStoryResult = Optional.absent();
    private static Optional<TestResult> forcedScenarioResult = Optional.absent();
    boolean addingScenarioOutlineSteps = false;
    String currentScenarioId;
    String currentScenario;
    FailureCause nestedResult;

    private void clearStoryResult() {
        forcedStoryResult = Optional.absent();
    }

    private void clearScenarioResult() {
        forcedScenarioResult = Optional.absent();
    }

    private boolean isPendingStory() {
        return forcedStoryResult.or((Object)TestResult.UNDEFINED) == TestResult.PENDING || forcedScenarioResult.or((Object)TestResult.UNDEFINED) == TestResult.PENDING;
    }

    private boolean isSkippedStory() {
        return forcedStoryResult.or((Object)TestResult.UNDEFINED) == TestResult.SKIPPED || forcedScenarioResult.or((Object)TestResult.UNDEFINED) == TestResult.SKIPPED;
    }

    public SerenityReporter(Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
        this.stepQueue = new LinkedList<Step>();
        this.thucydidesListenersThreadLocal = new ThreadLocal();
        this.baseStepListeners = Lists.newArrayList();
        this.clearStoryResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SerenityListeners getThucydidesListeners() {
        if (this.thucydidesListenersThreadLocal.get() == null) {
            SerenityListeners listeners = SerenityReports.setupListeners((Configuration)this.systemConfiguration);
            this.thucydidesListenersThreadLocal.set(listeners);
            List<BaseStepListener> list = this.baseStepListeners;
            synchronized (list) {
                this.baseStepListeners.add(listeners.getBaseStepListener());
            }
        }
        return this.thucydidesListenersThreadLocal.get();
    }

    protected ReportService getReportService() {
        return SerenityReports.getReportService((Configuration)this.systemConfiguration);
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
    }

    public void uri(String uri) {
        this.currentUri = uri;
        String featuresRoot = File.separatorChar + FEATURES_ROOT_PATH + File.separatorChar;
        if (uri.contains(featuresRoot)) {
            this.currentUri = uri.substring(uri.lastIndexOf(featuresRoot) + FEATURES_ROOT_PATH.length() + 2);
        }
        this.defaultFeatureId = new File(this.currentUri).getName().replace(".feature", "");
        this.defaultFeatureName = Inflector.getInstance().humanize(this.defaultFeatureId, new String[0]);
    }

    public void feature(Feature feature) {
        this.assureTestSuiteFinished();
        if (feature.getName().isEmpty()) {
            feature = this.featureWithDefaultName(feature, this.defaultFeatureName, this.defaultFeatureId);
        }
        this.currentFeature = feature;
        this.configureDriver(feature);
        this.getThucydidesListeners();
        Story userStory = Story.withIdAndPath((String)feature.getId(), (String)feature.getName(), (String)this.currentUri).asFeature();
        if (!StringUtils.isEmpty((CharSequence)feature.getDescription())) {
            userStory = userStory.withNarrative(feature.getDescription());
        }
        StepEventBus.getEventBus().testSuiteStarted(userStory);
        this.checkForPending(feature);
        this.checkForSkipped(feature);
    }

    private Feature featureWithDefaultName(Feature feature, String defaultName, String id) {
        return new Feature(feature.getComments(), feature.getTags(), feature.getKeyword(), defaultName, feature.getDescription(), feature.getLine(), id);
    }

    private void checkForPending(Feature feature) {
        if (this.isPending(feature.getTags())) {
            forcedStoryResult = Optional.of((Object)TestResult.PENDING);
            StepEventBus.getEventBus().suspendTest();
        }
    }

    private void checkForSkipped(Feature feature) {
        if (this.isSkippedOrWIP(feature.getTags())) {
            forcedStoryResult = Optional.of((Object)TestResult.SKIPPED);
            StepEventBus.getEventBus().suspendTest();
        }
    }

    private void checkForPendingScenario(List<Tag> tags) {
        if (this.isPending(tags)) {
            forcedScenarioResult = Optional.of((Object)TestResult.PENDING);
            StepEventBus.getEventBus().suspendTest();
        }
    }

    private void checkForSkippedScenario(List<Tag> tags) {
        if (this.isSkippedOrWIP(tags)) {
            forcedScenarioResult = Optional.of((Object)TestResult.SKIPPED);
            StepEventBus.getEventBus().suspendTest();
        }
    }

    private void checkForManualScenario(List<Tag> tags) {
        if (this.isManual(tags)) {
            forcedScenarioResult = Optional.of((Object)TestResult.SKIPPED);
            StepEventBus.getEventBus().testIsManual();
            StepEventBus.getEventBus().suspendTest();
        }
    }

    private boolean isPending(List<Tag> tags) {
        return this.hasTag("@pending", tags);
    }

    private boolean isManual(List<Tag> tags) {
        return this.hasTag("@manual", tags);
    }

    private boolean isSkippedOrWIP(List<Tag> tags) {
        for (Tag tag : tags) {
            if (!SKIPPED_TAGS.contains(tag.getName())) continue;
            return true;
        }
        return false;
    }

    private boolean hasTag(String tagName, List<Tag> tags) {
        for (Tag tag : tags) {
            if (!tag.getName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    private void configureDriver(Feature feature) {
        StepEventBus.getEventBus().setUniqueSession(this.systemConfiguration.shouldUseAUniqueBrowser());
        List<String> tags = this.getTagNamesFrom(feature.getTags());
        String requestedDriver = this.getDriverFrom(tags);
        if (StringUtils.isNotEmpty((CharSequence)requestedDriver)) {
            ThucydidesWebDriverSupport.initialize((String)requestedDriver);
        } else {
            ThucydidesWebDriverSupport.initialize();
        }
        this.uniqueBrowserTag = this.getUniqueBrowserTagFrom(tags);
    }

    private List<String> getTagNamesFrom(List<Tag> tags) {
        ArrayList tagNames = Lists.newArrayList();
        for (Tag tag : tags) {
            tagNames.add(tag.getName());
        }
        return tagNames;
    }

    private String getDriverFrom(List<String> tags) {
        String requestedDriver = null;
        for (String tag : tags) {
            if (!tag.startsWith("@driver:")) continue;
            requestedDriver = tag.substring(8);
        }
        return requestedDriver;
    }

    private boolean getUniqueBrowserTagFrom(List<String> tags) {
        for (String tag : tags) {
            if (!tag.equalsIgnoreCase("@uniqueBrowser")) continue;
            return true;
        }
        return false;
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.addingScenarioOutlineSteps = true;
    }

    public void examples(Examples examples) {
        this.addingScenarioOutlineSteps = false;
        this.reinitializeExamples();
        List examplesTableRows = examples.getRows();
        List<String> headers = this.getHeadersFrom(examplesTableRows);
        List<Map<String, String>> rows = this.getValuesFrom(examplesTableRows, headers);
        for (int i = 1; i < examplesTableRows.size(); ++i) {
            this.addRow(this.exampleRows, headers, (ExamplesTableRow)examplesTableRows.get(i));
        }
        String scenarioId = this.scenarioIdFrom(examples.getId());
        boolean newScenario = !scenarioId.equals(this.currentScenarioId);
        this.table = newScenario ? this.thucydidesTableFrom(headers, rows, examples.getName(), examples.getDescription()) : this.addTableRowsTo(this.table, headers, rows, examples.getName(), examples.getDescription());
        this.exampleCount = examples.getRows().size() - 1;
        this.currentScenarioId = scenarioId;
    }

    private String scenarioIdFrom(String scenarioIdOrExampleId) {
        String[] idElements = scenarioIdOrExampleId.split(";");
        return idElements.length >= 2 ? String.format("%s;%s", this.defaultFeatureId, idElements[1]) : "";
    }

    private void reinitializeExamples() {
        this.examplesRunning = true;
        this.currentExample = 0;
        this.exampleRows = new ArrayList<Map<String, String>>();
    }

    private List<String> getHeadersFrom(List<ExamplesTableRow> examplesTableRows) {
        ExamplesTableRow headerRow = examplesTableRows.get(0);
        return headerRow.getCells();
    }

    private List<Map<String, String>> getValuesFrom(List<ExamplesTableRow> examplesTableRows, List<String> headers) {
        ArrayList rows = Lists.newArrayList();
        for (int row = 1; row < examplesTableRows.size(); ++row) {
            LinkedHashMap rowValues = Maps.newLinkedHashMap();
            int column = 0;
            for (String cellValue : examplesTableRows.get(row).getCells()) {
                String columnName = headers.get(column++);
                rowValues.put(columnName, cellValue);
            }
            rows.add(rowValues);
        }
        return rows;
    }

    private void addRow(List<Map<String, String>> exampleRows, List<String> headers, ExamplesTableRow currentTableRow) {
        LinkedHashMap row = new LinkedHashMap();
        for (int j = 0; j < headers.size(); ++j) {
            row.put(headers.get(j), currentTableRow.getCells().get(j));
        }
        exampleRows.add(row);
    }

    private DataTable thucydidesTableFrom(List<String> headers, List<Map<String, String>> rows, String name, String description) {
        return DataTable.withHeaders(headers).andMappedRows(rows).andTitle(name).andDescription(description).build();
    }

    private DataTable addTableRowsTo(DataTable table, List<String> headers, List<Map<String, String>> rows, String name, String description) {
        table.startNewDataSet(name, description);
        for (Map<String, String> row : rows) {
            table.appendRow(this.rowValuesFrom(headers, row));
        }
        table.nextRow();
        return table;
    }

    private Map<String, String> rowValuesFrom(List<String> headers, Map<String, String> row) {
        HashMap rowValues = Maps.newHashMap();
        for (String header : headers) {
            rowValues.put(header, row.get(header));
        }
        return ImmutableMap.copyOf((Map)rowValues);
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        boolean newScenario = !this.scenarioIdFrom(scenario.getId()).equals(this.currentScenario);
        this.currentScenario = this.scenarioIdFrom(scenario.getId());
        if (this.examplesRunning) {
            if (newScenario) {
                this.startScenario(scenario.getName(), scenario.getDescription(), scenario.getTags());
                StepEventBus.getEventBus().useExamplesFrom(this.table);
            } else {
                StepEventBus.getEventBus().addNewExamplesFrom(this.table);
            }
            this.startExample();
        } else {
            this.startScenario(scenario.getName(), scenario.getDescription(), scenario.getTags());
        }
    }

    private void startScenario(String name, String description, List<Tag> tags) {
        StepEventBus.getEventBus().testStarted(name);
        StepEventBus.getEventBus().addDescriptionToCurrentTest(description);
        StepEventBus.getEventBus().addTagsToCurrentTest(this.convertCucumberTags(this.currentFeature.getTags()));
        StepEventBus.getEventBus().addTagsToCurrentTest(this.convertCucumberTags(tags));
        this.registerFeatureJiraIssues(this.currentFeature.getTags());
        this.registerScenarioJiraIssues(tags);
        this.checkForSkipped(this.currentFeature);
        this.checkForPending(this.currentFeature);
    }

    private void registerFeatureJiraIssues(List<Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            StepEventBus.getEventBus().addIssuesToCurrentStory(issues);
        }
    }

    private void registerScenarioJiraIssues(List<Tag> tags) {
        List<String> issues = this.extractJiraIssueTags(tags);
        if (!issues.isEmpty()) {
            StepEventBus.getEventBus().addIssuesToCurrentTest(issues);
        }
    }

    private List<TestTag> convertCucumberTags(List<Tag> cucumberTags) {
        ArrayList tags = Lists.newArrayList();
        for (Tag tag : cucumberTags) {
            tags.add(TestTag.withValue((String)tag.getName().substring(1)));
        }
        return ImmutableList.copyOf((Collection)tags);
    }

    private List<String> extractJiraIssueTags(List<Tag> cucumberTags) {
        ArrayList issues = Lists.newArrayList();
        for (Tag tag : cucumberTags) {
            if (tag.getName().startsWith("@issue:")) {
                String tagIssueValue = tag.getName().substring("@issue:".length());
                issues.add(tagIssueValue);
            }
            if (!tag.getName().startsWith("@issues:")) continue;
            String tagIssuesValues = tag.getName().substring("@issues:".length());
            issues.addAll(Arrays.asList(tagIssuesValues.split(",")));
        }
        return issues;
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        if (this.examplesRunning) {
            this.finishExample();
        } else {
            this.generateReports();
        }
        if (!this.useUniqueBrowser(scenario)) {
            ThucydidesWebDriverSupport.closeCurrentDrivers();
        }
    }

    private boolean useUniqueBrowser(Scenario scenario) {
        return this.uniqueBrowserTag || ThucydidesSystemProperty.THUCYDIDES_USE_UNIQUE_BROWSER.booleanFrom(this.systemConfiguration.getEnvironmentVariables(), Boolean.valueOf(false)) != false || this.useUniqueBrowserForThisScenario(scenario);
    }

    private boolean useUniqueBrowserForThisScenario(Scenario scenario) {
        return this.getUniqueBrowserTagFrom(this.getTagNamesFrom(scenario.getTags()));
    }

    private void startExample() {
        Map<String, String> data = this.exampleRows.get(this.currentExample);
        StepEventBus.getEventBus().clearStepFailures();
        StepEventBus.getEventBus().exampleStarted(data);
        ++this.currentExample;
    }

    private void finishExample() {
        StepEventBus.getEventBus().exampleFinished();
        --this.exampleCount;
        if (this.exampleCount == 0) {
            this.examplesRunning = false;
            this.generateReports();
        } else {
            this.examplesRunning = true;
        }
    }

    public void background(Background background) {
        this.waitingToProcessBackgroundSteps = true;
        StepEventBus.getEventBus().setBackgroundTitle(background.getName());
        StepEventBus.getEventBus().setBackgroundDescription(background.getDescription());
    }

    public void scenario(Scenario scenario) {
        this.configureDriver(this.currentFeature);
        this.clearScenarioResult();
        this.checkForPendingScenario(scenario.getTags());
        this.checkForSkippedScenario(scenario.getTags());
        this.checkForManualScenario(scenario.getTags());
    }

    public void step(Step step) {
        if (!this.addingScenarioOutlineSteps) {
            this.stepQueue.add(step);
        }
    }

    public void done() {
        this.assureTestSuiteFinished();
    }

    public void close() {
        this.assureTestSuiteFinished();
    }

    private void assureTestSuiteFinished() {
        if (this.currentFeature != null) {
            this.stepQueue.clear();
            StepEventBus.getEventBus().testSuiteFinished();
            StepEventBus.getEventBus().clear();
            Serenity.done();
            this.table = null;
        }
    }

    public void eof() {
    }

    public void before(Match match, Result result) {
        this.nestedResult = null;
    }

    public void result(Result result) {
        Step currentStep = this.stepQueue.poll();
        if ("passed".equals(result.getStatus())) {
            StepEventBus.getEventBus().stepFinished();
        } else if ("failed".equals(result.getStatus())) {
            this.failed(this.stepTitleFrom(currentStep), result.getError());
        } else if (Result.SKIPPED.equals(result)) {
            StepEventBus.getEventBus().stepIgnored();
        } else if (PENDING_STATUS.equals(result.getStatus())) {
            StepEventBus.getEventBus().stepPending();
        } else if (Result.UNDEFINED.equals(result)) {
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)this.stepTitleFrom(currentStep)));
            StepEventBus.getEventBus().stepPending();
        }
        if (this.stepQueue.isEmpty()) {
            if (this.waitingToProcessBackgroundSteps) {
                this.waitingToProcessBackgroundSteps = false;
            } else {
                if (this.examplesRunning) {
                    StepEventBus.getEventBus().stepFinished();
                }
                this.updatePendingResults();
                this.updateSkippedResults();
                StepEventBus.getEventBus().testFinished();
            }
        }
    }

    private void updatePendingResults() {
        if (this.isPendingStory()) {
            StepEventBus.getEventBus().setAllStepsTo(TestResult.PENDING);
        }
    }

    private void updateSkippedResults() {
        if (this.isSkippedStory()) {
            StepEventBus.getEventBus().setAllStepsTo(TestResult.SKIPPED);
        }
    }

    public void failed(String stepTitle, Throwable cause) {
        Throwable rootCause = new RootCauseAnalyzer(cause).getRootCause().toException();
        StepEventBus.getEventBus().updateCurrentStepTitle(stepTitle);
        if (this.isAssumptionFailure(rootCause)) {
            StepEventBus.getEventBus().assumptionViolated(rootCause.getMessage());
        } else {
            StepEventBus.getEventBus().stepFailed(new StepFailure(ExecutedStepDescription.withTitle((String)this.normalized(stepTitle)), rootCause));
        }
    }

    private boolean isAssumptionFailure(Throwable rootCause) {
        return AssumptionViolatedException.class.isAssignableFrom(rootCause.getClass());
    }

    public void after(Match match, Result result) {
    }

    public void match(Match match) {
        if (match instanceof StepDefinitionMatch) {
            Step currentStep = this.stepQueue.peek();
            String stepTitle = this.stepTitleFrom(currentStep);
            StepEventBus.getEventBus().stepStarted(ExecutedStepDescription.withTitle((String)stepTitle));
            StepEventBus.getEventBus().updateCurrentStepTitle(this.normalized(stepTitle));
        }
    }

    private String stepTitleFrom(Step currentStep) {
        return currentStep.getKeyword() + currentStep.getName() + this.embeddedTableDataIn(currentStep);
    }

    private String embeddedTableDataIn(Step currentStep) {
        return currentStep.getRows() == null || currentStep.getRows().isEmpty() ? "" : this.convertToTextTable(currentStep.getRows());
    }

    private String convertToTextTable(List<DataTableRow> rows) {
        StringBuilder textTable = new StringBuilder();
        textTable.append(System.lineSeparator());
        for (DataTableRow row : rows) {
            textTable.append("|");
            for (String cell : row.getCells()) {
                textTable.append(" ");
                textTable.append(cell);
                textTable.append(" |");
            }
            if (row == rows.get(rows.size() - 1)) continue;
            textTable.append(System.lineSeparator());
        }
        return textTable.toString();
    }

    public void embedding(String mimeType, byte[] data) {
    }

    public void write(String text) {
    }

    private synchronized void generateReports() {
        this.getReportService().generateReportsFor(this.getAllTestOutcomes());
    }

    public List<TestOutcome> getAllTestOutcomes() {
        return Lambda.flatten((Object)Lambda.extract(this.baseStepListeners, (Object)((BaseStepListener)Lambda.on(BaseStepListener.class)).getTestOutcomes()));
    }

    private String normalized(String value) {
        return value.replaceAll(OPEN_PARAM_CHAR, "{").replaceAll(CLOSE_PARAM_CHAR, "}");
    }
}

