/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.actors;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.serenitybdd.screenplay.Ability;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.abilities.BrowseTheWeb;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;

public class Cast {
    private WebdriverManager manager = (WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class);
    private final String WITH_NO_SPECIFIED_DRIVER = "";
    Map<String, Actor> actors = Maps.newHashMap();

    public Actor actorNamed(String actorName) {
        return this.actorNamed(actorName, "");
    }

    public Actor actorNamed(String actorName, String driver) {
        if (!this.actors.containsKey(actorName)) {
            Actor newActor = Actor.named((String)actorName);
            newActor.can((Ability)BrowseTheWeb.with((WebDriver)this.manager.getWebdriverByName(actorName, driver)));
            this.actors.put(actorName, newActor);
        }
        return this.actors.get(actorName);
    }

    public List<Actor> getActors() {
        return ImmutableList.copyOf(this.actors.values());
    }

    public void dismissAll() {
        this.actors.clear();
    }

    public BrowsingActorBuilder actorUsingBrowser(String driver) {
        return new BrowsingActorBuilder(this, driver);
    }

    public class BrowsingActorBuilder {
        private final Cast cast;
        private final String driver;

        public BrowsingActorBuilder(Cast cast, String driver) {
            this.cast = cast;
            this.driver = driver;
        }

        public Actor named(String actorName) {
            return this.cast.actorNamed(actorName, this.driver);
        }
    }
}

