/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.cucumber.model;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.serenitybdd.cucumber.CucumberWithSerenity;

public class StoredFeatureFile {
    private final String featureFileName;

    public StoredFeatureFile(String featureFileName) {
        this.featureFileName = featureFileName;
    }

    public URL asAClasspathResource() {
        return StoredFeatureFile.class.getClassLoader().getResource(this.featureFileName);
    }

    public boolean existsOnTheClasspath() {
        return this.asAClasspathResource() != null;
    }

    public static StoredFeatureFile withName(String featureFileName) {
        return new StoredFeatureFile(featureFileName);
    }

    public File onTheClasspath() {
        return new File(this.asAClasspathResource().getFile());
    }

    public boolean existsOnTheFileSystem() {
        return Files.exists(Paths.get(this.featureFileName, new String[0]), new LinkOption[0]);
    }

    public File onTheFileSystem() {
        return Paths.get(this.featureFileName, new String[0]).toFile();
    }

    public File fromTheConfiguredPaths() throws IOException {
        for (String path : CucumberWithSerenity.currentRuntimeOptions().getFeaturePaths()) {
            if (!Files.exists(this.candidatePath(path, this.featureFileName), new LinkOption[0])) continue;
            return this.candidatePath(path, this.featureFileName).toFile();
        }
        throw new IOException("No such feature file found for " + this.featureFileName);
    }

    private Path candidatePath(String path, String featureFileName) {
        return Paths.get(Joiner.on((String)File.separator).join((Object)path, (Object)featureFileName, new Object[0]), new String[0]);
    }
}

