/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.jbehave;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import net.serenitybdd.jbehave.SerenityReporter;
import net.serenitybdd.jbehave.converters.DateTimeConverter;
import net.serenitybdd.jbehave.converters.TimeConverter;
import net.serenitybdd.jbehave.converters.YearMonthConverter;
import net.thucydides.core.webdriver.DriverConfiguration;
import org.jbehave.core.Embeddable;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.configuration.ParanamerConfiguration;
import org.jbehave.core.failures.FailureStrategy;
import org.jbehave.core.failures.UUIDExceptionWrapper;
import org.jbehave.core.io.CodeLocations;
import org.jbehave.core.io.LoadFromClasspath;
import org.jbehave.core.io.ResourceLoader;
import org.jbehave.core.io.StoryLoader;
import org.jbehave.core.model.TableTransformers;
import org.jbehave.core.reporters.FilePrintStreamFactory;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.reporters.StoryReporter;
import org.jbehave.core.reporters.StoryReporterBuilder;
import org.jbehave.core.steps.ParameterConverters;
import org.junit.internal.AssumptionViolatedException;

public class SerenityJBehave {
    public static Configuration defaultConfiguration(DriverConfiguration systemConfiguration, List<Format> formats, Embeddable embeddable) {
        Class<?> embeddableClass = embeddable.getClass();
        Properties viewResources = new Properties();
        viewResources.put("decorateNonHtml", "true");
        TableTransformers tableTransformers = new TableTransformers();
        LoadFromClasspath utf8StoryLoader = new LoadFromClasspath(StandardCharsets.UTF_8);
        return new ParanamerConfiguration().useTableTransformers(tableTransformers).useParameterConverters(new ParameterConverters((ResourceLoader)utf8StoryLoader, tableTransformers).addConverters(new ParameterConverters.ParameterConverter[]{new ParameterConverters.DateConverter(), new DateTimeConverter(), new YearMonthConverter(), new TimeConverter(), new ParameterConverters.EnumConverter(), new ParameterConverters.EnumListConverter()})).useStoryReporterBuilder(new StoryReporterBuilder().withDefaultFormats().withFormats(formats.toArray(new Format[0])).withCodeLocation(CodeLocations.codeLocationFromClass(embeddableClass)).withViewResources(viewResources).withPathResolver((FilePrintStreamFactory.FilePathResolver)new FilePrintStreamFactory.ResolveToPackagedName()).withFailureTrace(true).withFailureTraceCompression(true).withReporters(new StoryReporter[]{new SerenityReporter(systemConfiguration)})).useStoryLoader((StoryLoader)utf8StoryLoader).useFailureStrategy((FailureStrategy)new IgnoreAssumptionViolations());
    }

    private static class IgnoreAssumptionViolations
    implements FailureStrategy {
        private IgnoreAssumptionViolations() {
        }

        public void handleFailure(Throwable throwable) throws Throwable {
            if (throwable instanceof AssumptionViolatedException) {
                return;
            }
            if (throwable instanceof UUIDExceptionWrapper) {
                if (throwable.getCause() instanceof AssumptionViolatedException) {
                    return;
                }
                throw throwable.getCause();
            }
            throw throwable;
        }
    }
}

