/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.rest.interactions;

import io.restassured.response.ValidatableResponse;
import java.util.function.Consumer;
import net.serenitybdd.annotations.Step;
import net.serenitybdd.markers.CanBeSilent;
import net.serenitybdd.rest.SerenityRest;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Interaction;
import net.serenitybdd.screenplay.Tasks;

public class Ensure
implements Interaction,
CanBeSilent {
    private final String description;
    private final Consumer<ValidatableResponse> check;
    private final boolean isSilent;

    public Ensure(String description, Consumer<ValidatableResponse> check, boolean isSilent) {
        this.description = description;
        this.check = check;
        this.isSilent = isSilent;
    }

    @Step(value="Ensure that #description")
    public <T extends Actor> void performAs(T actor) {
        this.check.accept(SerenityRest.then());
    }

    public static Ensure that(String description, Consumer<ValidatableResponse> check) {
        return (Ensure)Tasks.instrumented(Ensure.class, (Object[])new Object[]{description, check, false});
    }

    public static Ensure silentlyThat(Consumer<ValidatableResponse> check) {
        return (Ensure)Tasks.instrumented(Ensure.class, (Object[])new Object[]{"", check, true});
    }

    public boolean isSilent() {
        return this.isSilent;
    }
}

