/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.rest.questions;

import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.function.Consumer;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.BaseConsequence;
import net.serenitybdd.screenplay.rest.questions.LastResponse;

public class ResponseConsequence
extends BaseConsequence<Response> {
    private final Consumer<ValidatableResponse> expression;
    private final String message;

    ResponseConsequence(String message, Consumer<ValidatableResponse> expression) {
        this.message = message;
        this.expression = expression;
    }

    public String toString() {
        return this.message;
    }

    public void evaluateFor(Actor actor) {
        this.performSetupActionsAs(actor);
        this.expression.accept((ValidatableResponse)LastResponse.received().answeredBy(actor).then());
    }

    public static ResponseConsequence seeThatResponse(String message, Consumer<ValidatableResponse> expression) {
        return new ResponseConsequence(message, expression);
    }

    public static ResponseConsequence seeThatResponse(Consumer<ValidatableResponse> expression) {
        return new ResponseConsequence("A valid response is returned", expression);
    }
}

