/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay.rest.questions;

import java.util.ArrayList;
import java.util.List;
import net.serenitybdd.screenplay.Question;
import net.serenitybdd.screenplay.rest.questions.RestQueryFunction;
import net.serenitybdd.screenplay.rest.questions.RestQuestion;
import net.serenitybdd.screenplay.rest.questions.RestResponseFunction;
import net.serenitybdd.screenplay.rest.questions.Returning;
import net.serenitybdd.screenplay.rest.questions.To;

public class RestQuestionBuilder<T>
implements To<T>,
Returning<T> {
    private String name;
    private String endpoint;
    private List<RestQueryFunction> queries = new ArrayList<RestQueryFunction>();

    public To<T> about(String name) {
        this.name = name;
        return this;
    }

    @Override
    public Returning<T> to(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Override
    public Returning<T> with(RestQueryFunction query) {
        this.queries.add(query);
        return this;
    }

    @Override
    public Returning<T> withPathParameters(String param1, Object value1) {
        this.queries.add(request -> request.pathParam(param1, value1));
        return this;
    }

    @Override
    public Returning<T> withPathParameters(String param1, Object value1, Object ... otherParams) {
        this.queries.add(request -> request.pathParam(param1, value1));
        if (otherParams.length % 2 == 1) {
            throw new IllegalArgumentException("Invalid number of path parameters");
        }
        for (int paramIndex = 0; paramIndex < otherParams.length; paramIndex += 2) {
            String param = otherParams[paramIndex].toString();
            Object value = otherParams[paramIndex + 1];
            RestQueryFunction restQueryFunction = request -> request.pathParam(param, value);
            this.queries.add(restQueryFunction);
        }
        return this;
    }

    @Override
    public Returning<T> withQueryParameters(String param1, Object value1) {
        this.queries.add(request -> request.queryParam(param1, new Object[]{value1}));
        return this;
    }

    @Override
    public Returning<T> withQueryParameters(String param1, Object value1, Object ... otherParams) {
        this.queries.add(request -> request.queryParam(param1, new Object[]{value1}));
        if (otherParams.length % 2 == 1) {
            throw new IllegalArgumentException("Invalid number of query parameters");
        }
        for (int paramIndex = 0; paramIndex < otherParams.length; paramIndex += 2) {
            String param = otherParams[paramIndex].toString();
            Object value = otherParams[paramIndex + 1];
            this.queries.add(request -> request.queryParam(param, new Object[]{value}));
        }
        return this;
    }

    @Override
    public Question<T> returning(RestResponseFunction<T> response) {
        return new RestQuestion(this.name, this.endpoint, this.queries, response);
    }
}

