/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.screenplay;

import java.util.List;
import java.util.Optional;
import net.serenitybdd.screenplay.Actor;
import net.serenitybdd.screenplay.Consequence;
import net.serenitybdd.screenplay.Performable;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.events.CastActorEvent;
import net.thucydides.core.steps.events.StepEventBusEvent;
import net.thucydides.core.steps.events.StepFailedEvent;
import net.thucydides.core.steps.events.StepFinishedEvent;
import net.thucydides.core.steps.events.StepStartedEvent;
import net.thucydides.core.steps.events.UpdateOverallResultsEvent;
import net.thucydides.core.steps.session.TestSession;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.stacktrace.FailureCause;
import net.thucydides.model.steps.ExecutedStepDescription;
import net.thucydides.model.steps.StepFailure;

public class EventBusInterface {
    public static void castActor(String name) {
        if (!StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            return;
        }
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getParallelEventBus().castActor(name);
        } else {
            TestSession.addEvent((StepEventBusEvent)new CastActorEvent(name));
        }
    }

    public void reportStepFailureFor(Performable todo, Throwable e) {
        EventBusInterface.handleStepFailure(e, ExecutedStepDescription.of(todo.getClass(), (String)"attemptsTo"));
    }

    public <T> void reportStepFailureFor(Consequence<T> consequence, Throwable e) {
        EventBusInterface.handleStepFailure(e, ExecutedStepDescription.withTitle((String)consequence.toString()));
    }

    private static void handleStepFailure(Throwable e, ExecutedStepDescription taskDescription) {
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getParallelEventBus().stepFailed(new StepFailure(taskDescription, e));
        } else if (!TestSession.currentStepHasFailed()) {
            List screenshotList = TestSession.getTestSessionContext().getStepEventBus().takeScreenshots(TestResult.FAILURE);
            TestSession.addEvent((StepEventBusEvent)new StepFailedEvent(new StepFailure(taskDescription, e), screenshotList));
        }
    }

    public int getRunningStepCount() {
        return StepEventBus.getParallelEventBus().getBaseStepListener().getRunningStepCount();
    }

    public void mergePreviousStep() {
        StepEventBus.getParallelEventBus().mergePreviousStep();
    }

    public void updateOverallResult() {
        if (StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            if (!TestSession.isSessionStarted()) {
                StepEventBus.getParallelEventBus().updateOverallResults();
            } else {
                TestSession.addEvent((StepEventBusEvent)new UpdateOverallResultsEvent());
            }
        }
    }

    public void startQuestion(String title) {
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getParallelEventBus().stepStarted(ExecutedStepDescription.withTitle((String)title).asAQuestion());
        } else {
            TestSession.addEvent((StepEventBusEvent)new StepStartedEvent(ExecutedStepDescription.withTitle((String)title).asAQuestion()));
        }
    }

    public void finishQuestion() {
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getParallelEventBus().stepFinished();
        } else {
            TestSession.addEvent((StepEventBusEvent)new StepFinishedEvent());
        }
    }

    public void reportStepFinished() {
        if (!TestSession.isSessionStarted()) {
            StepEventBus.getParallelEventBus().stepFinished();
        } else {
            TestSession.addEvent((StepEventBusEvent)new StepFinishedEvent());
        }
    }

    public void reportStepIgnored() {
        StepEventBus.getParallelEventBus().stepIgnored();
    }

    public void reportStepSkippedFor(Performable todo) {
        ExecutedStepDescription taskDescription = ExecutedStepDescription.of(todo.getClass(), (String)"performAs");
        StepEventBus.getParallelEventBus().stepStarted(taskDescription);
        StepEventBus.getParallelEventBus().stepIgnored();
    }

    public boolean isBaseStepListenerRegistered() {
        return StepEventBus.getParallelEventBus().isBaseStepListenerRegistered();
    }

    public boolean aStepHasFailed() {
        return this.isBaseStepListenerRegistered() && StepEventBus.getParallelEventBus().getBaseStepListener().aStepHasFailed();
    }

    public boolean aStepHasFailedInTheCurrentExample() {
        return this.isBaseStepListenerRegistered() && StepEventBus.getParallelEventBus().getBaseStepListener().aStepHasFailedInTheCurrentExample();
    }

    public FailureCause getFailureCause() {
        return StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome().getTestFailureCause();
    }

    public Optional<FailureCause> failureCause() {
        if (StepEventBus.getParallelEventBus() == null || !StepEventBus.getParallelEventBus().isBaseStepListenerRegistered() || StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome() == null) {
            return Optional.empty();
        }
        if (StepEventBus.getParallelEventBus().getBaseStepListener().aStepHasFailed()) {
            if (StepEventBus.getParallelEventBus().getBaseStepListener().latestTestOutcome().isPresent()) {
                return Optional.ofNullable(StepEventBus.getParallelEventBus().getBaseStepListener().getCurrentTestOutcome().getTestFailureCause());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public boolean shouldIgnoreConsequences() {
        if (StepEventBus.getParallelEventBus().isDryRun()) {
            return true;
        }
        if (StepEventBus.getParallelEventBus().softAssertsActive() && !StepEventBus.getParallelEventBus().currentTestIsSuspended()) {
            return false;
        }
        return StepEventBus.getParallelEventBus().currentTestIsSuspended() || StepEventBus.getParallelEventBus().aStepInTheCurrentTestHasFailed();
    }

    public void enableSoftAsserts() {
        StepEventBus.getParallelEventBus().enableSoftAsserts();
    }

    public boolean softAssertsActive() {
        return StepEventBus.getParallelEventBus().softAssertsActive();
    }

    public void disableSoftAsserts() {
        StepEventBus.getParallelEventBus().disableSoftAsserts();
    }

    public void assignFactToActor(Actor actor, String fact) {
        if (!StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            return;
        }
        StepEventBus.getParallelEventBus().getBaseStepListener().latestTestOutcome().ifPresent(testOutcome -> testOutcome.assignFact(actor.getName(), fact));
    }

    public void assignAbilityToActor(Actor actor, String ability) {
        if (!StepEventBus.getParallelEventBus().isBaseStepListenerRegistered()) {
            return;
        }
        if (StepEventBus.getParallelEventBus().getBaseStepListener().latestTestOutcome() == null) {
            return;
        }
        StepEventBus.getParallelEventBus().getBaseStepListener().latestTestOutcome().ifPresent(testOutcome -> testOutcome.assignAbility(actor.getName(), ability));
    }
}

