/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.core;

import com.snowflake.client.core.BasicEvent;
import com.snowflake.client.core.EventUtil;
import com.snowflake.client.core.Incident;
import com.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;

public abstract class Event {
    private static final Logger logger = Logger.getLogger(Event.class.getName());
    private static final String EVENT_DUMP_FILE_NAME = "sf_event_";
    private static final String EVENT_DUMP_FILE_EXT = ".dmp.gz";
    private EventType type;
    private String message;

    public Event(EventType type, String message) {
        Preconditions.checkArgument(type.getEventClass() == this.getClass());
        this.type = type;
        this.message = message;
    }

    public EventType getType() {
        return this.type;
    }

    public void setType(EventType type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void writeEventDumpLine(String message) {
        String eventDumpPath = EventUtil.getDumpPathPrefix() + "/" + EVENT_DUMP_FILE_NAME + EventUtil.getDumpFileId() + EVENT_DUMP_FILE_EXT;
        if (new File(eventDumpPath).length() < EventUtil.getmaxDumpFileSizeBytes()) {
            try {
                GZIPOutputStream outStream = new GZIPOutputStream(new FileOutputStream(eventDumpPath, true));
                PrintWriter eventDumper = new PrintWriter(outStream, true);
                eventDumper.println(message);
                eventDumper.flush();
                eventDumper.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Could not open Event dump file " + eventDumpPath + ", exception: {0}", ex.getMessage());
            }
        } else {
            logger.log(Level.SEVERE, "Failed to dump Event because dump file is too large. Delete dump file or increase maximum dump file size.");
        }
    }

    public abstract void flush();

    public static enum EventType {
        INCIDENT(1, "INCIDENT", Incident.class),
        NETWORK_ERROR(2, "NETWORK ERROR", BasicEvent.class),
        STATE_TRANSITION(3, "STATE TRANSITION", BasicEvent.class),
        NONE(100, "NONE", BasicEvent.class);

        private final int id;
        private final String description;
        private final Class<? extends Event> eventClass;

        public int getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public Class<? extends Event> getEventClass() {
            return this.eventClass;
        }

        private EventType(int id, String description, Class<? extends Event> eventClass) {
            this.id = id;
            this.description = description;
            this.eventClass = eventClass;
        }
    }
}

