/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.http;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceResponse;
import com.snowflake.client.jdbc.internal.amazonaws.ResponseMetadata;
import com.snowflake.client.jdbc.internal.amazonaws.http.HttpResponse;
import com.snowflake.client.jdbc.internal.amazonaws.http.HttpResponseHandler;
import com.snowflake.client.jdbc.internal.amazonaws.transform.StaxUnmarshallerContext;
import com.snowflake.client.jdbc.internal.amazonaws.transform.Unmarshaller;
import com.snowflake.client.jdbc.internal.amazonaws.transform.VoidStaxUnmarshaller;
import com.snowflake.client.jdbc.internal.apache.commons.logging.Log;
import com.snowflake.client.jdbc.internal.apache.commons.logging.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;

public class StaxResponseHandler<T>
implements HttpResponseHandler<AmazonWebServiceResponse<T>> {
    private Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller;
    private static final Log log = LogFactory.getLog("com.snowflake.client.jdbc.internal.amazonaws.request");
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    public StaxResponseHandler(Unmarshaller<T, StaxUnmarshallerContext> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (this.responseUnmarshaller == null) {
            this.responseUnmarshaller = new VoidStaxUnmarshaller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        XMLEventReader eventReader;
        log.trace("Parsing service response XML");
        InputStream content = response.getContent();
        if (content == null) {
            content = new ByteArrayInputStream("<eof/>".getBytes());
        }
        XMLInputFactory xMLInputFactory = xmlInputFactory;
        synchronized (xMLInputFactory) {
            eventReader = xmlInputFactory.createXMLEventReader(content);
        }
        try {
            AmazonWebServiceResponse<T> awsResponse = new AmazonWebServiceResponse<T>();
            StaxUnmarshallerContext unmarshallerContext = new StaxUnmarshallerContext(eventReader, response.getHeaders());
            unmarshallerContext.registerMetadataExpression("ResponseMetadata/RequestId", 2, "AWS_REQUEST_ID");
            unmarshallerContext.registerMetadataExpression("requestId", 2, "AWS_REQUEST_ID");
            this.registerAdditionalMetadataExpressions(unmarshallerContext);
            T result = this.responseUnmarshaller.unmarshall(unmarshallerContext);
            awsResponse.setResult(result);
            Map<String, String> metadata = unmarshallerContext.getMetadata();
            Map<String, String> responseHeaders = response.getHeaders();
            if (responseHeaders != null && responseHeaders.get("x-amzn-RequestId") != null) {
                metadata.put("AWS_REQUEST_ID", responseHeaders.get("x-amzn-RequestId"));
            }
            awsResponse.setResponseMetadata(new ResponseMetadata(metadata));
            log.trace("Done parsing service response");
            AmazonWebServiceResponse<T> amazonWebServiceResponse = awsResponse;
            return amazonWebServiceResponse;
        }
        finally {
            try {
                eventReader.close();
            }
            catch (XMLStreamException e) {
                log.warn("Error closing xml parser", e);
            }
        }
    }

    protected void registerAdditionalMetadataExpressions(StaxUnmarshallerContext unmarshallerContext) {
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

