/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.core;

import com.snowflake.client.core.IncidentUtil;
import com.snowflake.client.core.SFBaseResultSet;
import com.snowflake.client.core.SFException;
import com.snowflake.client.core.SFResultSetMetaData;
import com.snowflake.client.jdbc.ErrorCode;
import com.snowflake.client.jdbc.SnowflakeFixedView;
import com.snowflake.client.jdbc.SnowflakeSQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFFixedViewResultSet
extends SFBaseResultSet {
    static final Logger logger = Logger.getLogger(SFFixedViewResultSet.class.getName());
    private SnowflakeFixedView fixedView;

    public SFFixedViewResultSet(SnowflakeFixedView fixedView) throws SnowflakeSQLException {
        this.fixedView = fixedView;
        try {
            this.resultSetMetaData = new SFResultSetMetaData(fixedView.describeColumns(), this.session, this.timestampNTZFormatter, this.timestampLTZFormatter, this.timestampTZFormatter, this.dateFormatter, this.timeFormatter);
            this.nextRow = new Object[this.resultSetMetaData.getColumnCount()];
        }
        catch (Exception ex) {
            throw new SnowflakeSQLException(ex, "XX000", (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "Failed to describe fixed view: " + fixedView.getClass().getName());
        }
    }

    @Override
    public boolean next() throws SFException {
        logger.log(Level.FINER, "next called");
        List<Object> nextRowList = null;
        try {
            nextRowList = this.fixedView.getNextRow();
        }
        catch (Exception ex) {
            SFException sfe = IncidentUtil.generateIncidentWithException(this.session, null, null, ex, ErrorCode.INTERNAL_ERROR, "Error getting next row from fixed view");
            throw sfe;
        }
        if (nextRowList == null) {
            logger.log(Level.FINER, "end of result");
            return false;
        }
        int colIdx = 0;
        for (Object colObj : nextRowList) {
            this.nextRow[colIdx++] = colObj;
        }
        return true;
    }
}

