/*
 * Decompiled with CFR 0.152.
 */
package com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import com.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import com.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import com.snowflake.client.jdbc.internal.amazonaws.Request;
import com.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import com.snowflake.client.jdbc.internal.amazonaws.services.kms.model.ListGrantsRequest;
import com.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import com.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import com.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;
import java.io.StringWriter;

public class ListGrantsRequestMarshaller
implements Marshaller<Request<ListGrantsRequest>, ListGrantsRequest> {
    @Override
    public Request<ListGrantsRequest> marshall(ListGrantsRequest listGrantsRequest) {
        if (listGrantsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListGrantsRequest> request = new DefaultRequest<ListGrantsRequest>(listGrantsRequest, "AWSKMS");
        String target = "TrentService.ListGrants";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (listGrantsRequest.getKeyId() != null) {
                jsonWriter.key("KeyId").value(listGrantsRequest.getKeyId());
            }
            if (listGrantsRequest.getLimit() != null) {
                jsonWriter.key("Limit").value(listGrantsRequest.getLimit());
            }
            if (listGrantsRequest.getMarker() != null) {
                jsonWriter.key("Marker").value(listGrantsRequest.getMarker());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

