/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.BasicAWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;

public class SystemPropertiesCredentialsProvider
implements AWSCredentialsProvider {
    @Override
    public AWSCredentials getCredentials() {
        String accessKey = StringUtils.trim(System.getProperty("aws.accessKeyId"));
        String secretKey = StringUtils.trim(System.getProperty("aws.secretKey"));
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            throw new AmazonClientException("Unable to load AWS credentials from Java system properties (aws.accessKeyId and aws.secretKey)");
        }
        return new BasicAWSCredentials(accessKey, secretKey);
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

