/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.transform;

import java.io.StringWriter;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonClientException;
import net.snowflake.client.jdbc.internal.amazonaws.DefaultRequest;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpMethodName;
import net.snowflake.client.jdbc.internal.amazonaws.services.kms.model.CreateKeyRequest;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Marshaller;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringInputStream;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;
import net.snowflake.client.jdbc.internal.amazonaws.util.json.JSONWriter;

public class CreateKeyRequestMarshaller
implements Marshaller<Request<CreateKeyRequest>, CreateKeyRequest> {
    @Override
    public Request<CreateKeyRequest> marshall(CreateKeyRequest createKeyRequest) {
        if (createKeyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateKeyRequest> request = new DefaultRequest<CreateKeyRequest>(createKeyRequest, "AWSKMS");
        String target = "TrentService.CreateKey";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter(stringWriter);
            jsonWriter.object();
            if (createKeyRequest.getPolicy() != null) {
                jsonWriter.key("Policy").value(createKeyRequest.getPolicy());
            }
            if (createKeyRequest.getDescription() != null) {
                jsonWriter.key("Description").value(createKeyRequest.getDescription());
            }
            if (createKeyRequest.getKeyUsage() != null) {
                jsonWriter.key("KeyUsage").value(createKeyRequest.getKeyUsage());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent(new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

