/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import net.snowflake.client.core.IncidentUtil;
import net.snowflake.client.core.SFBaseResultSet;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFChildResult;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTime;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFTimestamp;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.util.TimeUtil;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class ResultUtil {
    static final SFLogger logger = SFLoggerFactory.getLogger(ResultUtil.class);
    public static final int MILLIS_IN_ONE_DAY = 86400000;
    public static final int DEFAULT_SCALE_OF_SFTIME_FRACTION_SECONDS = 3;
    private static TimeZone timeZoneUTC = TimeZone.getTimeZone("UTC");
    private static final Map<String, Object> defaultParameters;

    public static Object effectiveParamValue(Map<String, Object> parameters, String paramName) {
        String upper = paramName.toUpperCase();
        Object value = parameters.get(upper);
        if (value != null) {
            return value;
        }
        value = defaultParameters.get(upper);
        if (value != null) {
            return value;
        }
        logger.debug("Unknown Common Parameter: {}", paramName);
        return null;
    }

    public static SnowflakeDateTimeFormat specializedFormatter(Map<String, Object> parameters, String id, String param, String defaultFormat) {
        String sqlFormat = SnowflakeDateTimeFormat.effectiveSpecializedTimestampFormat((String)ResultUtil.effectiveParamValue(parameters, param), defaultFormat);
        SnowflakeDateTimeFormat formatter = SnowflakeDateTimeFormat.fromSqlFormat(sqlFormat);
        Object[] objectArray = new Object[4];
        objectArray[0] = id;
        objectArray[1] = sqlFormat;
        objectArray[2] = id;
        objectArray[3] = formatter::toSimpleDateTimePattern;
        logger.debug("sql {} format: {}, java {} format: {}", objectArray);
        return formatter;
    }

    public static Timestamp adjustTimestamp(Timestamp timestamp) {
        long milliToAdjust = ResultUtil.msDiffJulianToGregorian(timestamp);
        if (milliToAdjust != 0L) {
            logger.debug("adjust timestamp by {} days", () -> milliToAdjust / 86400000L);
            Timestamp newTimestamp = new Timestamp(timestamp.getTime() + milliToAdjust);
            newTimestamp.setNanos(timestamp.getNanos());
            return newTimestamp;
        }
        return timestamp;
    }

    public static long msDiffJulianToGregorian(java.util.Date date) {
        if (date.getTime() < -12220156800000L) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int year = cal.get(1);
            int month = cal.get(2);
            int dayOfMonth = cal.get(5);
            if (month == 0 || month == 1 && dayOfMonth <= 28) {
                --year;
            }
            int hundreds = year / 100;
            int differenceInDays = hundreds - hundreds / 4 - 2;
            return differenceInDays * 86400000;
        }
        return 0L;
    }

    public static SFTimestamp getSFTimestamp(String timestampStr, int scale, int internalColumnType, long resultVersion, TimeZone sessionTZ, SFBaseSession session) throws SFException {
        logger.debug("public Timestamp getTimestamp(int columnIndex)");
        try {
            TimeUtil.TimestampType tsType = null;
            switch (internalColumnType) {
                case 93: {
                    tsType = TimeUtil.TimestampType.TIMESTAMP_NTZ;
                    break;
                }
                case 50001: {
                    tsType = TimeUtil.TimestampType.TIMESTAMP_TZ;
                    logger.trace("Handle timestamp with timezone {} encoding: {}", resultVersion > 0L ? "new" : "old", timestampStr);
                    break;
                }
                case 50000: {
                    tsType = TimeUtil.TimestampType.TIMESTAMP_LTZ;
                }
            }
            return TimeUtil.getSFTimestamp(timestampStr, scale, tsType, resultVersion, sessionTZ);
        }
        catch (IllegalArgumentException ex) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.IO_ERROR, "Invalid timestamp value: " + timestampStr), null, null);
        }
    }

    public static SFTime getSFTime(String obj, int scale, SFBaseSession session) throws SFException {
        try {
            return TimeUtil.getSFTime(obj, scale);
        }
        catch (IllegalArgumentException ex) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.INTERNAL_ERROR, "Invalid time value: " + obj), null, null);
        }
    }

    public static String getSFTimeAsString(SFTime sft, int scale, SnowflakeDateTimeFormat timeFormatter) {
        return timeFormatter.format(sft, scale);
    }

    public static String getBooleanAsString(boolean bool) {
        return bool ? "TRUE" : "FALSE";
    }

    public static String getSFTimestampAsString(SFTimestamp sfTS, int columnType, int scale, SnowflakeDateTimeFormat timestampNTZFormatter, SnowflakeDateTimeFormat timestampLTZFormatter, SnowflakeDateTimeFormat timestampTZFormatter, SFBaseSession session) throws SFException {
        SnowflakeDateTimeFormat formatter = columnType == 93 ? timestampNTZFormatter : (columnType == 50000 ? timestampLTZFormatter : timestampTZFormatter);
        if (formatter == null) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.INTERNAL_ERROR, "missing timestamp formatter"), null, null);
        }
        try {
            Timestamp adjustedTimestamp = ResultUtil.adjustTimestamp(sfTS.getTimestamp());
            return formatter.format(adjustedTimestamp, sfTS.getTimeZone(), scale);
        }
        catch (SFTimestamp.TimestampOperationNotAvailableException e) {
            BigDecimal nanosSinceEpoch = sfTS.getNanosSinceEpoch();
            BigDecimal secondsSinceEpoch = nanosSinceEpoch.scaleByPowerOfTen(-9);
            return secondsSinceEpoch.setScale(scale).toPlainString();
        }
    }

    public static String getDateAsString(Date date, SnowflakeDateTimeFormat dateFormatter) {
        return dateFormatter.format((java.util.Date)date, TimeZone.getDefault());
    }

    public static Date adjustDate(Date date) {
        long milliToAdjust = ResultUtil.msDiffJulianToGregorian(date);
        if (milliToAdjust != 0L) {
            return new Date(date.getTime() + milliToAdjust);
        }
        return date;
    }

    @Deprecated
    public static Date getDate(String str, TimeZone tz, SFBaseSession session) throws SFException {
        try {
            long milliSecsSinceEpoch = Long.valueOf(str) * 86400000L;
            SFTimestamp tsInUTC = SFTimestamp.fromDate(new Date(milliSecsSinceEpoch), 0, TimeZone.getTimeZone("UTC"));
            SFTimestamp tsInClientTZ = tsInUTC.moveToTimeZone(tz);
            logger.debug("getDate: tz offset={}", () -> tsInClientTZ.getTimeZone().getOffset(tsInClientTZ.getTime()));
            Date preDate = new Date(tsInClientTZ.getTime());
            Date newDate = ResultUtil.adjustDate(preDate);
            Object[] objectArray = new Object[2];
            objectArray[0] = preDate::toString;
            objectArray[1] = newDate::toString;
            logger.debug("Adjust date from {} to {}", objectArray);
            return newDate;
        }
        catch (NumberFormatException ex) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.INTERNAL_ERROR, "Invalid date value: " + str), null, null);
        }
    }

    public static boolean getBoolean(String str) {
        return str.equalsIgnoreCase(Boolean.TRUE.toString()) || str.equals("1");
    }

    public static long calculateUpdateCount(SFBaseResultSet resultSet) throws SFException, SQLException {
        long updateCount = 0L;
        SFStatementType statementType = resultSet.getStatementType();
        if (statementType.isDML()) {
            while (resultSet.next()) {
                if (statementType == SFStatementType.COPY) {
                    SFResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    int columnIndex = resultSetMetaData.getColumnIndex("rows_loaded");
                    updateCount += columnIndex == -1 ? 0L : resultSet.getLong(columnIndex + 1);
                    continue;
                }
                if (statementType == SFStatementType.INSERT || statementType == SFStatementType.UPDATE || statementType == SFStatementType.DELETE || statementType == SFStatementType.MERGE || statementType == SFStatementType.MULTI_INSERT) {
                    int columnCount = resultSet.getMetaData().getColumnCount();
                    for (int i = 0; i < columnCount; ++i) {
                        updateCount += resultSet.getLong(i + 1);
                    }
                    continue;
                }
                updateCount = 0L;
            }
        } else {
            updateCount = statementType.isGenerateResultSet() ? -1L : 0L;
        }
        return updateCount;
    }

    public static int listSearchCaseInsensitive(List<String> source, String target) {
        for (int i = 0; i < source.size(); ++i) {
            if (!target.equalsIgnoreCase(source.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static List<String> getResultIds(JsonNode result) {
        JsonNode resultIds = result.path("data").path("resultIds");
        if (resultIds.isNull() || resultIds.isMissingNode() || resultIds.asText().isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(Arrays.asList(resultIds.asText().split(",")));
    }

    private static List<SFStatementType> getResultTypes(JsonNode result) {
        JsonNode resultTypes = result.path("data").path("resultTypes");
        if (resultTypes.isNull() || resultTypes.isMissingNode() || resultTypes.asText().isEmpty()) {
            return Collections.emptyList();
        }
        String[] typeStrs = resultTypes.asText().split(",");
        ArrayList<SFStatementType> res = new ArrayList<SFStatementType>();
        for (String typeStr : typeStrs) {
            long typeId = Long.valueOf(typeStr);
            res.add(SFStatementType.lookUpTypeById(typeId));
        }
        return res;
    }

    public static List<SFChildResult> getChildResults(SFBaseSession session, String requestId, JsonNode result) throws SFException {
        List<String> ids = ResultUtil.getResultIds(result);
        List<SFStatementType> types = ResultUtil.getResultTypes(result);
        if (ids.size() != types.size()) {
            throw (SFException)IncidentUtil.generateIncidentV2WithException(session, new SFException(ErrorCode.CHILD_RESULT_IDS_AND_TYPES_DIFFERENT_SIZES, ids.size(), types.size()), null, requestId);
        }
        ArrayList<SFChildResult> res = new ArrayList<SFChildResult>();
        for (int i = 0; i < ids.size(); ++i) {
            res.add(new SFChildResult(ids.get(i), types.get(i)));
        }
        return res;
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TIMEZONE", "America/Los_Angeles");
        map.put("TIMESTAMP_OUTPUT_FORMAT", "DY, DD MON YYYY HH24:MI:SS TZHTZM");
        map.put("TIMESTAMP_NTZ_OUTPUT_FORMAT", "");
        map.put("TIMESTAMP_LTZ_OUTPUT_FORMAT", "");
        map.put("TIMESTAMP_TZ_OUTPUT_FORMAT", "");
        map.put("DATE_OUTPUT_FORMAT", "YYYY-MM-DD");
        map.put("TIME_OUTPUT_FORMAT", "HH24:MI:SS");
        map.put("CLIENT_HONOR_CLIENT_TZ_FOR_TIMESTAMP_NTZ", Boolean.TRUE);
        map.put("CLIENT_DISABLE_INCIDENTS", Boolean.TRUE);
        map.put("BINARY_OUTPUT_FORMAT", "HEX");
        defaultParameters = map;
    }
}

