/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.apache.arrow.vector.util;

import java.util.Iterator;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.util.ArrowBufPointer;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.util.hash.ArrowBufHasher;
import net.snowflake.client.jdbc.internal.apache.arrow.memory.util.hash.SimpleHasher;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ElementAddressableVector;

public class ElementAddressableVectorIterator<T extends ElementAddressableVector>
implements Iterator<ArrowBufPointer> {
    private final T vector;
    private int index = 0;
    private final ArrowBufPointer reusablePointer;

    public ElementAddressableVectorIterator(T vector) {
        this(vector, SimpleHasher.INSTANCE);
    }

    public ElementAddressableVectorIterator(T vector, ArrowBufHasher hasher) {
        this.vector = vector;
        this.reusablePointer = new ArrowBufPointer(hasher);
    }

    @Override
    public boolean hasNext() {
        return this.index < this.vector.getValueCount();
    }

    @Override
    public ArrowBufPointer next() {
        this.vector.getDataPointer(this.index, this.reusablePointer);
        ++this.index;
        return this.reusablePointer;
    }

    public void next(ArrowBufPointer outPointer) {
        this.vector.getDataPointer(this.index, outPointer);
        ++this.index;
    }
}

