/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.RestRequest;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.apache.commons.io.IOUtils;
import net.snowflake.client.jdbc.internal.apache.http.HttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.HttpClient;
import net.snowflake.client.jdbc.internal.apache.http.client.config.RequestConfig;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.apache.http.config.Registry;
import net.snowflake.client.jdbc.internal.apache.http.config.RegistryBuilder;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.ConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.socket.PlainConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.ssl.SSLConnectionSocketFactory;
import net.snowflake.client.jdbc.internal.apache.http.conn.ssl.SSLContexts;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.DefaultRedirectStrategy;
import net.snowflake.client.jdbc.internal.apache.http.impl.client.HttpClientBuilder;
import net.snowflake.client.jdbc.internal.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class HttpUtil {
    static final SFLogger logger = SFLoggerFactory.getLogger(HttpUtil.class);
    public static final int DEFAULT_MAX_CONNECTIONS = 100;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 100;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    public static final int DEFAULT_HTTP_CLIENT_SOCKET_TIMEOUT = 300000;
    private static HttpClient httpClient = null;
    private static PoolingHttpClientConnectionManager connectionManager = null;
    private static RequestConfig DefaultRequestConfig = null;

    private static HttpClient buildHttpClient() {
        DefaultRequestConfig = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(300000).build();
        SSLContext sslContext = SSLContexts.createDefault();
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, new String[]{"TLSv1.2"}, null, SSLConnectionSocketFactory.STRICT_HOSTNAME_VERIFIER);
        Registry<ConnectionSocketFactory> registry = RegistryBuilder.create().register("https", sslSocketFactory).register("http", (SSLConnectionSocketFactory)((Object)PlainConnectionSocketFactory.getSocketFactory())).build();
        connectionManager = new PoolingHttpClientConnectionManager(registry);
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(100);
        httpClient = HttpClientBuilder.create().setDefaultRequestConfig(DefaultRequestConfig).setConnectionManager(connectionManager).useSystemProperties().setRedirectStrategy(new DefaultRedirectStrategy()).setUserAgent("-").build();
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpClient getHttpClient() {
        if (httpClient != null) return httpClient;
        Class<HttpUtil> clazz = HttpUtil.class;
        synchronized (HttpUtil.class) {
            if (httpClient != null) return httpClient;
            httpClient = HttpUtil.buildHttpClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return httpClient;
        }
    }

    public static final RequestConfig getDefaultRequestConfigWithSocketTimeout(int soTimeoutMs) {
        HttpUtil.getHttpClient();
        return RequestConfig.copy(DefaultRequestConfig).setSocketTimeout(soTimeoutMs).build();
    }

    public static String getHttpClientStats() {
        if (connectionManager == null) {
            return "";
        }
        return connectionManager.getTotalStats().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String executeRequest(HttpRequestBase httpRequest, HttpClient httpClient, int retryTimeout, int injectSocketTimeout, AtomicBoolean canceling) throws SnowflakeSQLException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Pool: {} Executing: {}", HttpUtil.getHttpClientStats(), httpRequest);
        }
        String theString = null;
        StringWriter writer = null;
        try {
            HttpResponse response = RestRequest.execute(httpClient, httpRequest, retryTimeout, injectSocketTimeout, canceling);
            if (response == null || response.getStatusLine().getStatusCode() != 200) {
                logger.error("Error executing request: {}", httpRequest.toString());
                SnowflakeUtil.logResponseDetails(response, logger);
                throw new SnowflakeSQLException("58030", ErrorCode.NETWORK_ERROR.getMessageCode(), "HTTP status=" + (response != null ? Integer.valueOf(response.getStatusLine().getStatusCode()) : "null response"));
            }
            writer = new StringWriter();
            IOUtils.copy(response.getEntity().getContent(), writer, "UTF-8");
            theString = writer.toString();
        }
        finally {
            httpRequest.releaseConnection();
            if (writer != null) {
                writer.close();
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Pool: {} Request returned for: {}", HttpUtil.getHttpClientStats(), httpRequest);
        }
        return theString;
    }

    public static final class HttpInputStream
    extends InputStream {
        private final InputStream httpIn;

        public HttpInputStream(InputStream httpIn) {
            this.httpIn = httpIn;
        }

        @Override
        public final int available() throws IOException {
            int available = this.httpIn.available();
            return available == 0 ? 1 : available;
        }

        @Override
        public final int read() throws IOException {
            return this.httpIn.read();
        }

        @Override
        public final int read(byte[] b) throws IOException {
            return this.httpIn.read(b);
        }

        @Override
        public final int read(byte[] b, int off, int len) throws IOException {
            return this.httpIn.read(b, off, len);
        }

        @Override
        public final long skip(long n) throws IOException {
            return this.httpIn.skip(n);
        }

        @Override
        public final void close() throws IOException {
            this.httpIn.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.httpIn.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.httpIn.reset();
        }

        @Override
        public final boolean markSupported() {
            return this.httpIn.markSupported();
        }
    }
}

