/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.BlobProperties;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.ListBlobItem;
import java.net.URISyntaxException;
import net.snowflake.client.jdbc.cloud.storage.StorageProviderException;
import net.snowflake.client.jdbc.internal.amazonaws.services.s3.model.S3ObjectSummary;

public class StorageObjectSummary {
    private String location;
    private String key;
    private String eTag;
    private long size;

    private StorageObjectSummary(String location, String key, String eTag, long size) {
        this.location = location;
        this.key = key;
        this.eTag = eTag;
        this.size = size;
    }

    public static StorageObjectSummary createFromS3ObjectSummary(S3ObjectSummary objSummary) {
        return new StorageObjectSummary(objSummary.getBucketName(), objSummary.getKey(), objSummary.getETag(), objSummary.getSize());
    }

    public static StorageObjectSummary createFromAzureListBlobItem(ListBlobItem listBlobItem) throws StorageProviderException {
        long size;
        String eTag;
        String key;
        String location;
        try {
            location = listBlobItem.getContainer().getName();
            CloudBlob cloudBlob = (CloudBlob)listBlobItem;
            key = cloudBlob.getName();
            BlobProperties blobProperties = cloudBlob.getProperties();
            eTag = blobProperties.getEtag();
            size = blobProperties.getLength();
        }
        catch (StorageException | URISyntaxException ex) {
            throw new StorageProviderException(ex);
        }
        return new StorageObjectSummary(location, key, eTag, size);
    }

    public String getLocation() {
        return this.location;
    }

    public String getKey() {
        return this.key;
    }

    public String getETag() {
        return this.eTag;
    }

    public long getSize() {
        return this.size;
    }
}

