/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.internal.auth;

import java.net.URI;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceClient;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceRequest;
import net.snowflake.client.jdbc.internal.amazonaws.Request;
import net.snowflake.client.jdbc.internal.amazonaws.auth.Signer;
import net.snowflake.client.jdbc.internal.amazonaws.auth.SignerFactory;
import net.snowflake.client.jdbc.internal.amazonaws.auth.SignerParams;
import net.snowflake.client.jdbc.internal.amazonaws.auth.SignerTypeAware;
import net.snowflake.client.jdbc.internal.amazonaws.internal.auth.SignerProvider;
import net.snowflake.client.jdbc.internal.amazonaws.internal.auth.SignerProviderContext;
import net.snowflake.client.jdbc.internal.amazonaws.util.AwsHostNameUtils;

public class DefaultSignerProvider
extends SignerProvider {
    private final AmazonWebServiceClient awsClient;
    private final Signer defaultSigner;

    public DefaultSignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.defaultSigner = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext context) {
        Request<?> request = context.getRequest();
        if (request == null || this.shouldUseDefaultSigner(request.getOriginalRequest())) {
            if (context.isRedirect()) {
                return this.awsClient.getSignerByURI(context.getUri());
            }
            return this.defaultSigner;
        }
        SignerTypeAware signerTypeAware = (SignerTypeAware)((Object)request.getOriginalRequest());
        SignerParams params = new SignerParams(this.awsClient.getServiceName(), this.getSigningRegionForRequestURI(request.getEndpoint()));
        return SignerFactory.createSigner(signerTypeAware.getSignerType(), params);
    }

    private boolean shouldUseDefaultSigner(AmazonWebServiceRequest originalRequest) {
        return !(originalRequest instanceof SignerTypeAware) || this.isSignerOverridden();
    }

    private boolean isSignerOverridden() {
        return this.awsClient.getSignerOverride() != null;
    }

    private String getSigningRegionForRequestURI(URI uri) {
        String regionName = this.awsClient.getSignerRegionOverride();
        if (regionName == null) {
            regionName = AwsHostNameUtils.parseRegion(uri.getHost(), this.awsClient.getServiceName());
        }
        return regionName;
    }
}

