/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.TimeZone;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.DBMetadataResultSetMetadata;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeBaseResultSet;
import net.snowflake.client.jdbc.SnowflakeConnectionV1;
import net.snowflake.client.jdbc.SnowflakeResultSetMetaData;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

class SnowflakeDatabaseMetaDataResultSet
extends SnowflakeBaseResultSet {
    protected ResultSet showObjectResultSet;
    protected Statement statement;
    protected Object[][] rows;
    static final SFLogger logger = SFLoggerFactory.getLogger(SnowflakeDatabaseMetaDataResultSet.class);

    public SnowflakeDatabaseMetaDataResultSet() {
    }

    public SnowflakeDatabaseMetaDataResultSet(List<String> columnNames, List<String> columnTypeNames, List<Integer> columnTypes, ResultSet showObjectResultSet, Statement statement) throws SQLException {
        this.showObjectResultSet = showObjectResultSet;
        SFSession session = ((SnowflakeConnectionV1)statement.getConnection()).getSfSession();
        this.resultSetMetaData = new SnowflakeResultSetMetaData(columnNames.size(), columnNames, columnTypeNames, columnTypes, session);
        this.nextRow = new Object[columnNames.size()];
        this.statement = statement;
    }

    public SnowflakeDatabaseMetaDataResultSet(List<String> columnNames, List<String> columnTypeNames, List<Integer> columnTypes, Object[][] rows, Statement statement) throws SQLException {
        this.rows = rows;
        SFSession session = ((SnowflakeConnectionV1)statement.getConnection()).getSfSession();
        this.resultSetMetaData = new SnowflakeResultSetMetaData(columnNames.size(), columnNames, columnTypeNames, columnTypes, session);
        this.nextRow = new Object[columnNames.size()];
        this.statement = statement;
    }

    public SnowflakeDatabaseMetaDataResultSet(DBMetadataResultSetMetadata metadataType, ResultSet resultSet, Statement statement) throws SQLException {
        this(metadataType.getColumnNames(), metadataType.getColumnTypeNames(), metadataType.getColumnTypes(), resultSet, statement);
    }

    public SnowflakeDatabaseMetaDataResultSet(DBMetadataResultSetMetadata metadataType, Object[][] rows, Statement statement) throws SQLException {
        this(metadataType.getColumnNames(), metadataType.getColumnTypeNames(), metadataType.getColumnTypes(), rows, statement);
    }

    @Override
    public boolean next() throws SQLException {
        logger.debug("public boolean next()");
        if (this.row < this.rows.length) {
            this.nextRow = this.rows[this.row++];
            return true;
        }
        this.statement.close();
        this.statement = null;
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
            this.statement = null;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str != null) {
            return str.getBytes();
        }
        throw new SQLException("Cannot get bytes on null column");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        Object obj = this.getObjectInternal(columnIndex);
        if (obj instanceof Time) {
            return (Time)obj;
        }
        throw new SnowflakeSQLException(ErrorCode.INVALID_VALUE_CONVERT, obj.getClass().getName(), "TIME", obj);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, TimeZone tz) throws SQLException {
        Object obj = this.getObjectInternal(columnIndex);
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        throw new SnowflakeSQLException(ErrorCode.INVALID_VALUE_CONVERT, obj.getClass().getName(), "TIMESTAMP", obj);
    }

    @Override
    public Date getDate(int columnIndex, TimeZone tz) throws SQLException {
        Object obj = this.getObjectInternal(columnIndex);
        if (obj instanceof Date) {
            return (Date)obj;
        }
        throw new SnowflakeSQLException(ErrorCode.INVALID_VALUE_CONVERT, obj.getClass().getName(), "DATE", obj);
    }

    static ResultSet getEmptyResultSet(DBMetadataResultSetMetadata metadataType, Statement statement) throws SQLException {
        return new SnowflakeDatabaseMetaDataResultSet(metadataType, new Object[0][], statement);
    }
}

