/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.telemetryV2;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.CloseableHttpResponse;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpRequestBase;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;
import net.snowflake.client.jdbc.telemetryV2.TelemetryEvent;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class TelemetryService {
    private static final SFLogger logger = SFLoggerFactory.getLogger(TelemetryService.class);
    private static ThreadLocal<TelemetryService> _threadLocal = new ThreadLocal<TelemetryService>(){

        @Override
        protected TelemetryService initialValue() {
            return new TelemetryService();
        }
    };
    private static HashSet<String> ENABLED_DEPLOYMENT = new HashSet<String>(Arrays.asList(TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.DEV), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.REG), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.QA1), TELEMETRY_SERVER_DEPLOYMENT.access$100(TELEMETRY_SERVER_DEPLOYMENT.PREPROD2)));
    private LinkedList<TelemetryEvent> queue = new LinkedList();
    private int BATCH_SIZE = 100;
    private TELEMETRY_SERVER_DEPLOYMENT serverDeployment;
    private boolean enabled = false;
    private JSONObject context;

    public static TelemetryService getInstance() {
        return _threadLocal.get();
    }

    private TelemetryService() {
        try {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(new RuntimePermission("shutdownHooks"));
            }
            Runtime.getRuntime().addShutdownHook(new TelemetryUploader(this));
        }
        catch (SecurityException e) {
            logger.info("Failed to add shutdown hook for telemetry service");
        }
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public JSONObject getContext() {
        return this.context;
    }

    public void updateContext(Map<String, String> params) {
        Properties info = new Properties();
        for (String key : params.keySet()) {
            String val = params.get(key);
            if (val == null) continue;
            info.put(key, val);
        }
        this.updateContext(params.get("uri"), info);
    }

    public void updateContext(String url, Properties info) {
        this.configureDeployment(url, info.getProperty("account"), info.getProperty("port"));
        Enumeration<?> names = info.propertyNames();
        this.context = new JSONObject();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.compareTo("password") == 0 || name.compareTo("privateKey") == 0) continue;
            this.context.put(name, info.getProperty(name));
        }
    }

    private void configureDeployment(String url, String account, String port) {
        TelemetryService instance = TelemetryService.getInstance();
        TELEMETRY_SERVER_DEPLOYMENT deployment = TELEMETRY_SERVER_DEPLOYMENT.PROD;
        if (url != null) {
            if (url.contains("reg") || url.contains("local")) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.REG;
                if (port != null && port.compareTo("8080") == 0 || url.contains("8080")) {
                    deployment = TELEMETRY_SERVER_DEPLOYMENT.DEV;
                }
            } else if (url.contains("qa1") || account != null && account.contains("qa1")) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.QA1;
            } else if (url.contains("preprod2")) {
                deployment = TELEMETRY_SERVER_DEPLOYMENT.PREPROD2;
            }
        }
        instance.setDeployment(deployment);
    }

    public TelemetryEvent getEvent(int i) {
        if (this.queue != null && this.queue.size() > i && i >= 0) {
            return this.queue.get(i);
        }
        return null;
    }

    public void setDeployment(TELEMETRY_SERVER_DEPLOYMENT deployment) {
        this.serverDeployment = deployment;
    }

    public String getServerDeploymentName() {
        return this.serverDeployment.name;
    }

    public void add(TelemetryEvent event) {
        if (!this.enabled) {
            return;
        }
        this.queue.add(event);
        if (this.queue.size() >= this.BATCH_SIZE) {
            new TelemetryUploader(this).start();
        }
    }

    public void flush() {
        if (!this.enabled) {
            return;
        }
        if (!this.queue.isEmpty()) {
            new TelemetryUploader(this).start();
        }
    }

    public String logsToString(LinkedList<TelemetryEvent> queue) {
        JSONArray logs = new JSONArray();
        for (TelemetryEvent event : queue) {
            logs.add(event);
        }
        return logs.toString();
    }

    public int size() {
        return this.queue.size();
    }

    public void logHttpRequestError(HttpRequestBase request, int injectSocketTimeout, AtomicBoolean canceling, boolean withoutCookies, boolean includeRetryParameters, boolean includeRequestGuid, CloseableHttpResponse response, String breakRetryReason, long retryTimeout, int retryCount, String sqlState, int errorCode) {
        if (this.enabled) {
            TelemetryEvent.LogBuilder logBuilder = new TelemetryEvent.LogBuilder();
            JSONObject value = new JSONObject();
            String name = response == null ? "null http response" : "http response with code " + response.getStatusLine().getStatusCode();
            value.put("request", request.toString());
            value.put("retryTimeout", retryTimeout);
            value.put("injectSocketTimeout", injectSocketTimeout);
            value.put("canceling", canceling == null ? "null" : Boolean.valueOf(canceling.get()));
            value.put("withoutCookies", withoutCookies);
            value.put("includeRetryParameters", includeRetryParameters);
            value.put("includeRequestGuid", includeRequestGuid);
            value.put("response", response);
            value.put("breakRetryReason", breakRetryReason);
            value.put("retryTimeout", retryTimeout);
            value.put("retryCount", retryCount);
            value.put("sqlState", sqlState);
            value.put("errorCode", errorCode);
            TelemetryEvent log = ((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)((TelemetryEvent.LogBuilder)logBuilder.withName(name)).withValue(value).withTag("sqlState", sqlState)).withTag("errorCode", errorCode)).build();
            this.add(log);
        }
    }

    static /* synthetic */ TELEMETRY_SERVER_DEPLOYMENT access$600(TelemetryService x0) {
        return x0.serverDeployment;
    }

    static /* synthetic */ HashSet access$700() {
        return ENABLED_DEPLOYMENT;
    }

    static class TelemetryUploader
    extends Thread {
        TelemetryService instance;

        public TelemetryUploader(TelemetryService _instance) {
            this.instance = _instance;
        }

        @Override
        public void run() {
            if (!this.instance.enabled) {
                return;
            }
            if (this.instance.queue.isEmpty()) {
                logger.debug("skip to run telemetry uploader for empty queue");
            } else {
                this.flushQueue();
                logger.debug("run telemetry uploader");
            }
        }

        /*
         * Exception decompiling
         */
        private void flushQueue() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static enum TELEMETRY_SERVER_DEPLOYMENT {
        DEV("dev", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.SFCTEST)),
        REG("reg", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.SFCTEST)),
        QA1("qa1", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.SFCDEV)),
        PREPROD2("preprod2", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.SFCDEV)),
        PROD("prod", TELEMETRY_SERVER_URL.access$200(TELEMETRY_SERVER_URL.US2)),
        NONEXISTENT("nonexistent", "https://nonexist.execute-api.us-west-2.amazonaws.com/sfctest/enqueue");

        private final String name;
        private final String url;

        private TELEMETRY_SERVER_DEPLOYMENT(String name, String url) {
            this.name = name;
            this.url = url;
        }

        public String getURL() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }

        static /* synthetic */ String access$800(TELEMETRY_SERVER_DEPLOYMENT x0) {
            return x0.url;
        }
    }

    private static enum TELEMETRY_SERVER_URL {
        SFCTEST("https://lximwp8945.execute-api.us-west-2.amazonaws.com/sfctest/enqueue"),
        SFCDEV("https://lol6l3j52m.execute-api.us-west-2.amazonaws.com/sfcdev/enqueue"),
        US2("https://lol6l3j52m.execute-api.us-west-2.amazonaws.com/sfctest/enqueue");

        private final String url;

        private TELEMETRY_SERVER_URL(String url) {
            this.url = url;
        }

        static /* synthetic */ String access$200(TELEMETRY_SERVER_URL x0) {
            return x0.url;
        }
    }
}

